// Interrupt      Flag       Interrupt Handler Address
// External 0     IE0         0003h
// Timer 0        TF0         000Bh
// External 1     IE1         0013h
// Timer 1        TF1         001Bh
// Serial         RI/TI       0023h

//response template for GPiB command 1 (init controller)
//00 02 f8 01  d0 02 01 20
//01 21 01 01  00 00 34 38
//20 54 50 49  20 44 53 20
//44 44 20 46  4c 4f 50 50
//59 20 20 20  20 33 30 30
//32 33 37 2d  30 30 00 02
//09 00 02 00

#ifndef _OPCODES_H_
  #define _OPCODES_H_
  
  // Opcode lenght table is used to determine how many bytes
  // need each opcode to calculate next opcode address
  // and jump address information
  uint8_t opcodeLen[] = {
    //0, 1, 2, 3, 4, 5, 6, 7, 8, 9, A, B, C, D, E, F
      1, 2, 3, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,   // 0x0_
      3, 2, 3, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,   // 0x1_
      3, 2, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,   // 0x2_
      3, 2, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,   // 0x3_

      2, 2, 2, 3, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,   // 0x4_
      2, 2, 2, 3, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,   // 0x5_
      2, 2, 2, 3, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,   // 0x6_
      2, 2, 2, 1, 2, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,   // 0x7_
      
      2, 2, 2, 1, 1, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,   // 0x8_
      3, 2, 2, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,   // 0x9_
      2, 2, 2, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,   // 0xA_
      2, 2, 2, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,   // 0xB_
      
      2, 2, 2, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,   // 0xC_
      2, 2, 2, 1, 1, 3, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2,   // 0xD_
      1, 2, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,   // 0xE_
      1, 2, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1    // 0xF_
  };
  
  // RAM[0x20 - 0x2F] can be accessed as bits in bitRAM[0x00 - 0x7F]
  // Bit addressable registers can be accessed as bits in bitRAM[0x80 - 0xFF] +/-
  // Some register bit have names. See 8051 manual
  // see Intel App note AP-70 page4 (page8 PDF), Figure 4
  
  // register adresses
  #define P0    0x80  // * Bit addresable
  #define SP    0x81
  #define DPL   0x82
  #define DPH   0x83
  #define PCON  0x87
  
  #define TCON  0x88  // * Bit addresable
  #define TMOD  0x89
  #define TL0   0x8A
  #define TL1   0x8B
  #define TH0   0x8C
  #define TH1   0x8D

  #define P1    0x90  // * Bit addresable
  #define SCON  0x98  // * Bit addresable
  #define SBUF  0x99
  
  #define P2    0xA0  // * Bit addresable
  #define IE    0xA8  // * Bit addresable

  #define P3    0xB0  // * Bit addresable
  #define IP    0xB8  // * Bit addresable

  #define PSW   0xD0  // * Bit addresable
  #define ACC   0xE0  // * Bit addresable

  #define regB  0xF0  // * Bit addresable

  struct registerType {
    uint8_t num;
    const char *name;
  };

  // bit addresable register names
  // num not used yet
  // works because araay order is correctly filled and aligned
  const struct registerType registers[] = {
    {0, "Port0"},
    {1, "TCON"},
    {2, "Port1"},
    {3, "SCON"},
    {4, "Port2"},
    {5, "IntEnable"},
    {6, "Port3"},
    {7, "IntPriority"},
    {8, "Unknown8"},
    {9, "Unknown9"},
    {10, "PSW"},
    {11, "Unknown11"},
    {12, "accumulator"},
    {13, "Unknown13"},
    {14, "regB"},
    {15, "Unknown15"}
  };

#endif
