#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <stdbool.h>

// nice routines from friend
#define bitRead(value, bit) (((value) >> (bit)) & 0x01)
#define bitSet(value, bit) ((value) |= (1UL << (bit)))
#define bitClear(value, bit) ((value) &= ~(1UL << (bit)))
#define bitToggle(value, bit) ((value) ^= (1UL << (bit)))
#define bitWrite(value, bit, bitvalue) ((bitvalue) ? bitSet(value, bit) : bitClear(value, bit))

#define bit0 0
#define bit1 1
#define bit2 2
#define bit3 3
#define bit4 4
#define bit5 5
#define bit6 6
#define bit7 7

uint8_t Port0, Port1, Port2, Port3;
uint8_t TCON, SCON, IntEnable, IntPriority, PSW;

uint8_t RAM[0x100];
uint8_t accumulator, regB, tmp8;
uint8_t R0, R1, R2, R3, R4, R5, R6, R7;
uint16_t DPTR, tmp16;
bool carry, tmpCarry;

int main(int argc, char **argv) {

label_000:	// addr: 000	opcodes: 01 25
	goto label_025; // absolute jump
label_002:	// addr: 002	opcodes: FF
	R7 = accumulator;
label_003:	// addr: 003	opcodes: 21 FB
	goto label_1FB; // absolute jump
label_005:	// addr: 005	opcodes: FF
	R7 = accumulator;
label_006:	// addr: 006	opcodes: FF
	R7 = accumulator;
label_007:	// addr: 007	opcodes: FF
	R7 = accumulator;
label_008:	// addr: 008	opcodes: FF
	R7 = accumulator;
label_009:	// addr: 009	opcodes: FF
	R7 = accumulator;
label_00A:	// addr: 00A	opcodes: FF
	R7 = accumulator;
label_00B:	// addr: 00B	opcodes: 21 C4
	goto label_1C4; // absolute jump
label_00D:	// addr: 00D	opcodes: FF
	R7 = accumulator;
label_00E:	// addr: 00E	opcodes: FF
	R7 = accumulator;
label_00F:	// addr: 00F	opcodes: FF
	R7 = accumulator;
label_010:	// addr: 010	opcodes: FF
	R7 = accumulator;
label_011:	// addr: 011	opcodes: FF
	R7 = accumulator;
label_012:	// addr: 012	opcodes: FF
	R7 = accumulator;
label_013:	// addr: 013	opcodes: 21 97
	goto label_197; // absolute jump
label_015:	// addr: 015	opcodes: FF
	R7 = accumulator;
label_016:	// addr: 016	opcodes: FF
	R7 = accumulator;
label_017:	// addr: 017	opcodes: FF
	R7 = accumulator;
label_018:	// addr: 018	opcodes: FF
	R7 = accumulator;
label_019:	// addr: 019	opcodes: FF
	R7 = accumulator;
label_01A:	// addr: 01A	opcodes: FF
	R7 = accumulator;
label_01B:	// addr: 01B	opcodes: 21 FB
	goto label_1FB; // absolute jump
label_01D:	// addr: 01D	opcodes: FF
	R7 = accumulator;
label_01E:	// addr: 01E	opcodes: FF
	R7 = accumulator;
label_01F:	// addr: 01F	opcodes: FF
	R7 = accumulator;
label_020:	// addr: 020	opcodes: FF
	R7 = accumulator;
label_021:	// addr: 021	opcodes: FF
	R7 = accumulator;
label_022:	// addr: 022	opcodes: FF
	R7 = accumulator;
label_023:	// addr: 023	opcodes: 21 FB
	goto label_1FB; // absolute jump
label_025:	// addr: 025	opcodes: 75 81 4F
	RAM[0x81] = 0x4F;
	// addr: 028	opcodes: 7A 00
	R2 = 0x00;
	// addr: 02A	opcodes: 75 46 00
	RAM[0x46] = 0x00;
	// addr: 02D	opcodes: 12 01 17
	label_117(); // long call
	// addr: 030	opcodes: 12 0A 0A
	label_A0A(); // long call
label_033:	// addr: 033	opcodes: D2 96
	bitSet(Port1, bit6);
label_035:	// addr: 035	opcodes: E5 90
	accumulator = RAM[0x90];
	// addr: 037	opcodes: F4
	accumulator = ~accumulator;
	// addr: 038	opcodes: 54 14
	accumulator &= 0x14;
	// addr: 03A	opcodes: F5 20
	RAM[0x20] = accumulator;
	// addr: 03C	opcodes: 30 02 F4
	if (bitRead(RAM[0x20], bit2) == false) goto label_033;
	// addr: 03F	opcodes: C2 96
	bitClear(Port1, bit6);
	// addr: 041	opcodes: 30 04 F1
	if (bitRead(RAM[0x20], bit4) == false) goto label_035;
	// addr: 044	opcodes: C2 95
	bitClear(Port1, bit5);
	// addr: 046	opcodes: 12 0B 28
	label_B28(); // long call
	// addr: 049	opcodes: 75 20 00
	RAM[0x20] = 0x00;
	// addr: 04C	opcodes: EA
	accumulator = R2;
	// addr: 04D	opcodes: B5 22 0A
	if (accumulator != RAM[0x22]) goto label_05A;
	// addr: 050	opcodes: 12 0B 33
	label_B33(); // long call
	// addr: 053	opcodes: D2 08
	bitSet(RAM[0x21], bit0);
	// addr: 055	opcodes: 12 08 5D
	label_85D(); // long call
	// addr: 058	opcodes: 80 DB
	goto label_035;
label_05A:	// addr: 05A	opcodes: B5 23 12
	if (accumulator != RAM[0x23]) goto label_06F;
	// addr: 05D	opcodes: 12 0B 33
	label_B33(); // long call
	// addr: 060	opcodes: D2 0B
	bitSet(RAM[0x21], bit3);
	// addr: 062	opcodes: 43 90 EF
	RAM[0x90] |= 0xEF;
	// addr: 065	opcodes: 12 09 71
	label_971(); // long call
	// addr: 068	opcodes: 43 90 9F
	RAM[0x90] |= 0x9F;
	// addr: 06B	opcodes: C2 96
	bitClear(Port1, bit6);
	// addr: 06D	opcodes: 80 C6
	goto label_035;
label_06F:	// addr: 06F	opcodes: B4 18 12
	if (accumulator != 0x18) goto label_084;
	// addr: 072	opcodes: A2 31
	if (bitRead(RAM[0x26], bit1) == true) {
	carry = true;
	} else {
		carry = false;
	};
	// addr: 074	opcodes: 40 07
	if ( carry ) goto label_07D;
	// addr: 076	opcodes: D2 35
	bitSet(RAM[0x26], bit5);
	// addr: 078	opcodes: 12 0B 3F
	label_B3F(); // long call
	// addr: 07B	opcodes: 01 35
	goto label_035; // absolute jump
label_07D:	// addr: 07D	opcodes: 12 0B 33
	label_B33(); // long call
	// addr: 080	opcodes: D2 0A
	bitSet(RAM[0x21], bit2);
	// addr: 082	opcodes: 01 35
	goto label_035; // absolute jump
label_084:	// addr: 084	opcodes: B4 14 08
	if (accumulator != 0x14) goto label_08F;
	// addr: 087	opcodes: 12 0B 33
	label_B33(); // long call
	// addr: 08A	opcodes: 12 01 17
	label_117(); // long call
	// addr: 08D	opcodes: 01 35
	goto label_035; // absolute jump
label_08F:	// addr: 08F	opcodes: B4 19 15
	if (accumulator != 0x19) goto label_0A7;
	// addr: 092	opcodes: A2 31
	if (bitRead(RAM[0x26], bit1) == true) {
	carry = true;
	} else {
		carry = false;
	};
	// addr: 094	opcodes: 40 07
	if ( carry ) goto label_09D;
	// addr: 096	opcodes: 12 0B 3F
	label_B3F(); // long call
	// addr: 099	opcodes: C2 35
	bitClear(RAM[0x26], bit5);
	// addr: 09B	opcodes: 01 D2
	goto label_0D2; // absolute jump
label_09D:	// addr: 09D	opcodes: 12 0B 33
	label_B33(); // long call
	// addr: 0A0	opcodes: 75 20 00
	RAM[0x20] = 0x00;
	// addr: 0A3	opcodes: D2 0B
	bitSet(RAM[0x21], bit3);
	// addr: 0A5	opcodes: 80 8E
	goto label_035;
label_0A7:	// addr: 0A7	opcodes: B4 5F 41
	if (accumulator != 0x5F) goto label_0EB;
	// addr: 0AA	opcodes: 30 0B 65
	if (bitRead(RAM[0x21], bit3) == false) goto label_112;
	// addr: 0AD	opcodes: 12 0B 33
	label_B33(); // long call
	// addr: 0B0	opcodes: A2 31
	if (bitRead(RAM[0x26], bit1) == true) {
	carry = true;
	} else {
		carry = false;
	};
	// addr: 0B2	opcodes: 50 28
	if ( carry == false ) goto label_0DC;
	// addr: 0B4	opcodes: 75 21 00
	RAM[0x21] = 0x00;
	// addr: 0B7	opcodes: E5 3A
	accumulator = RAM[0x3A];
	// addr: 0B9	opcodes: B4 05 02
	if (accumulator != 0x05) goto label_0BE;
	// addr: 0BC	opcodes: 01 C1
	goto label_0C1; // absolute jump
label_0BE:	// addr: 0BE	opcodes: B4 11 07
	if (accumulator != 0x11) goto label_0C8;
label_0C1:	// addr: 0C1	opcodes: 75 25 10
	RAM[0x25] = 0x10;
	// addr: 0C4	opcodes: 78 06
	R0 = 0x06;
	// addr: 0C6	opcodes: 79 00
	R1 = 0x00;
label_0C8:	// addr: 0C8	opcodes: 20 2C 07
	if (bitRead(RAM[0x25], bit4) == true) goto label_0D2;
	// addr: 0CB	opcodes: 78 FF
	R0 = 0xFF;
	// addr: 0CD	opcodes: 79 01
	R1 = 0x01;
	// addr: 0CF	opcodes: 75 25 40
	RAM[0x25] = 0x40;
label_0D2:	// addr: 0D2	opcodes: C2 31
	bitClear(RAM[0x26], bit1);
	// addr: 0D4	opcodes: 75 20 00
	RAM[0x20] = 0x00;
	// addr: 0D7	opcodes: 75 21 00
	RAM[0x21] = 0x00;
	// addr: 0DA	opcodes: 01 35
	goto label_035; // absolute jump
label_0DC:	// addr: 0DC	opcodes: 75 21 00
	RAM[0x21] = 0x00;
	// addr: 0DF	opcodes: 75 20 00
	RAM[0x20] = 0x00;
	// addr: 0E2	opcodes: 78 09
	R0 = 0x09;
	// addr: 0E4	opcodes: 79 00
	R1 = 0x00;
	// addr: 0E6	opcodes: 75 25 01
	RAM[0x25] = 0x01;
	// addr: 0E9	opcodes: 01 35
	goto label_035; // absolute jump
label_0EB:	// addr: 0EB	opcodes: B4 3F 24
	if (accumulator != 0x3F) goto label_112;
	// addr: 0EE	opcodes: 30 08 21
	if (bitRead(RAM[0x21], bit0) == false) goto label_112;
	// addr: 0F1	opcodes: 12 0B 33
	label_B33(); // long call
	// addr: 0F4	opcodes: 30 28 05
	if (bitRead(RAM[0x25], bit0) == false) goto label_0FC;
	// addr: 0F7	opcodes: 12 08 C6
	label_8C6(); // long call
	// addr: 0FA	opcodes: 21 07
	goto label_107; // absolute jump
label_0FC:	// addr: 0FC	opcodes: 20 2A 05
	if (bitRead(RAM[0x25], bit2) == true) goto label_104;
	// addr: 0FF	opcodes: 12 02 26
	label_226(); // long call
	// addr: 102	opcodes: 21 07
	goto label_107; // absolute jump
label_104:	// addr: 104	opcodes: 12 0A 76
	label_A76(); // long call
label_107:	// addr: 107	opcodes: 75 21 00
	RAM[0x21] = 0x00;
	// addr: 10A	opcodes: A2 31
	if (bitRead(RAM[0x26], bit1) == true) {
	carry = true;
	} else {
		carry = false;
	};
	// addr: 10C	opcodes: 50 02
	if ( carry == false ) goto label_110;
	// addr: 10E	opcodes: C2 93
	bitClear(Port1, bit3);
label_110:	// addr: 110	opcodes: 01 35
	goto label_035; // absolute jump
label_112:	// addr: 112	opcodes: 12 0B 3F
	label_B3F(); // long call
	// addr: 115	opcodes: 01 35
	goto label_035; // absolute jump
label_117:	// addr: 117	opcodes: D2 B5
	bitSet(Port3, bit5);
	// addr: 119	opcodes: D2 93
	bitSet(Port1, bit3);
	// addr: 11B	opcodes: C2 B0
	bitClear(Port3, bit0);
	// addr: 11D	opcodes: C2 B1
	bitClear(Port3, bit1);
	// addr: 11F	opcodes: C2 B4
	bitClear(Port3, bit4);
	// addr: 121	opcodes: C2 34
	bitClear(RAM[0x26], bit4);
	// addr: 123	opcodes: C2 31
	bitClear(RAM[0x26], bit1);
	// addr: 125	opcodes: C2 35
	bitClear(RAM[0x26], bit5);
	// addr: 127	opcodes: 75 34 00
	RAM[0x34] = 0x00;
	// addr: 12A	opcodes: 75 3A 00
	RAM[0x3A] = 0x00;
	// addr: 12D	opcodes: 75 A8 00
	RAM[0xA8] = 0x00;
	// addr: 130	opcodes: 75 88 04
	RAM[0x88] = 0x04;
	// addr: 133	opcodes: 75 B8 04
	RAM[0xB8] = 0x04;
	// addr: 136	opcodes: EA
	accumulator = R2;
	// addr: 137	opcodes: B4 14 02
	if (accumulator != 0x14) goto label_13C;
	// addr: 13A	opcodes: 80 06
	goto label_142;
label_13C:	// addr: 13C	opcodes: 75 30 0F
	RAM[0x30] = 0x0F;
	// addr: 13F	opcodes: 12 01 4F
	label_14F(); // long call
label_142:	// addr: 142	opcodes: 75 A8 84
	RAM[0xA8] = 0x84;
	// addr: 145	opcodes: 31 6F
	label_16F(); // absolute call
label_147:	// addr: 147	opcodes: 78 09
	R0 = 0x09;
	// addr: 149	opcodes: 79 00
	R1 = 0x00;
	// addr: 14B	opcodes: 75 25 01
	RAM[0x25] = 0x01;
	// addr: 14E	opcodes: 22
	return; // return (opcode: 0x22)
label_14F:	// addr: 14F	opcodes: 78 20
	R0 = 0x20;
	// addr: 151	opcodes: 76 00
	RAM[R0] = 0x00;
	// addr: 153	opcodes: 08
	R0++;
	// addr: 154	opcodes: D5 30 F8
	RAM[0x30]--;
if (RAM[0x30] == 0) goto label_14F;
	// addr: 157	opcodes: 43 21 00
	RAM[0x21] |= 0x00;
	// addr: 15A	opcodes: D2 95
	bitSet(Port1, bit5);
	// addr: 15C	opcodes: D2 96
	bitSet(Port1, bit6);
	// addr: 15E	opcodes: 90 30 00
	DPTR = 0x3000;
	// addr: 161	opcodes: E0
	accumulator = extRAM[DPTR];	// external RAM
	// addr: 162	opcodes: F5 22
	RAM[0x22] = accumulator;
	// addr: 164	opcodes: D2 15
	bitSet(RAM[0x22], bit5);
	// addr: 166	opcodes: F5 23
	RAM[0x23] = accumulator;
	// addr: 168	opcodes: D2 1E
	bitSet(RAM[0x23], bit6);
	// addr: 16A	opcodes: 75 4C FF
	RAM[0x4C] = 0xFF;
	// addr: 16D	opcodes: 80 D8
	goto label_147;
label_16F:	// addr: 16F	opcodes: 75 27 00
	RAM[0x27] = 0x00;
	// addr: 172	opcodes: 75 41 00
	RAM[0x41] = 0x00;
	// addr: 175	opcodes: C2 32
	bitClear(RAM[0x26], bit2);
	// addr: 177	opcodes: C2 36
	bitClear(RAM[0x26], bit6);
	// addr: 179	opcodes: E5 46
	accumulator = RAM[0x46];
	// addr: 17B	opcodes: 60 01
	if ( accumulator == 0 ) goto label_17E;
	// addr: 17D	opcodes: 22
	return; // return (opcode: 0x22)
label_17E:	// addr: 17E	opcodes: 75 34 01
	RAM[0x34] = 0x01;
	// addr: 181	opcodes: 12 07 B9
	label_7B9(); // long call
	// addr: 184	opcodes: E5 27
	accumulator = RAM[0x27];
	// addr: 186	opcodes: 60 05
	if ( accumulator == 0 ) goto label_18D;
	// addr: 188	opcodes: 75 46 01
	RAM[0x46] = 0x01;
	// addr: 18B	opcodes: 80 03
	goto label_190;
label_18D:	// addr: 18D	opcodes: 75 46 03
	RAM[0x46] = 0x03;
label_190:	// addr: 190	opcodes: 12 08 12
	label_812(); // long call
	// addr: 193	opcodes: 75 34 00
	RAM[0x34] = 0x00;
	// addr: 196	opcodes: 22
	return; // return (opcode: 0x22)
label_197:	// addr: 197	opcodes: C0 D0
	// Warning: PUSH 0xD0 not implemented Yet!
	// addr: 199	opcodes: C0 E0
	// Warning: PUSH 0xE0 not implemented Yet!
	// addr: 19B	opcodes: C0 F0
	// Warning: PUSH 0xF0 not implemented Yet!
	// addr: 19D	opcodes: C0 82
	// Warning: PUSH 0x82 not implemented Yet!
	// addr: 19F	opcodes: C0 83
	// Warning: PUSH 0x83 not implemented Yet!
	// addr: 1A1	opcodes: C2 30
	bitClear(RAM[0x26], bit0);
	// addr: 1A3	opcodes: C2 AF
	bitClear(IntEnable, bit7);
	// addr: 1A5	opcodes: 90 20 00
	DPTR = 0x2000;
	// addr: 1A8	opcodes: E0
	accumulator = extRAM[DPTR];	// external RAM
	// addr: 1A9	opcodes: 54 80
	accumulator &= 0x80;
	// addr: 1AB	opcodes: 60 05
	if ( accumulator == 0 ) goto label_1B2;
	// addr: 1AD	opcodes: 12 08 12
	label_812(); // long call
	// addr: 1B0	opcodes: 80 05
	goto label_1B7;
label_1B2:	// addr: 1B2	opcodes: DF 03
	R7--;
if (R7 != 0) goto label_1B7;
	// addr: 1B4	opcodes: 12 08 12
	label_812(); // long call
label_1B7:	// addr: 1B7	opcodes: D2 AF
	bitSet(IntEnable, bit7);
	// addr: 1B9	opcodes: D0 83
	// Warning: POP 0x83 not implemented Yet!
	// addr: 1BB	opcodes: D0 82
	// Warning: POP 0x82 not implemented Yet!
	// addr: 1BD	opcodes: D0 F0
	// Warning: POP 0xF0 not implemented Yet!
	// addr: 1BF	opcodes: D0 E0
	// Warning: POP 0xE0 not implemented Yet!
	// addr: 1C1	opcodes: D0 D0
	// Warning: POP 0xD0 not implemented Yet!
	// addr: 1C3	opcodes: 32
	return; // return form IRQ (opcode: 0x32)
label_1C4:	// addr: 1C4	opcodes: C0 D0
	// Warning: PUSH 0xD0 not implemented Yet!
	// addr: 1C6	opcodes: C0 E0
	// Warning: PUSH 0xE0 not implemented Yet!
	// addr: 1C8	opcodes: C0 F0
	// Warning: PUSH 0xF0 not implemented Yet!
	// addr: 1CA	opcodes: C0 82
	// Warning: PUSH 0x82 not implemented Yet!
	// addr: 1CC	opcodes: C0 83
	// Warning: PUSH 0x83 not implemented Yet!
	// addr: 1CE	opcodes: C2 8C
	bitClear(TCON, bit4);
	// addr: 1D0	opcodes: E5 2A
	accumulator = RAM[0x2A];
	// addr: 1D2	opcodes: 60 04
	if ( accumulator == 0 ) goto label_1D8;
	// addr: 1D4	opcodes: C3
	carry = false; // clear carry
	// addr: 1D5	opcodes: 9F
	// Warning: SUBB a, Rr, flags not fully implemented
accumulator -= carry ? 1 : 0;	// carry affected!
accumulator -= R7;	// carry affected!
	// addr: 1D6	opcodes: 60 13
	if ( accumulator == 0 ) goto label_1EB;
label_1D8:	// addr: 1D8	opcodes: EF
	accumulator = R7;
	// addr: 1D9	opcodes: F5 2A
	RAM[0x2A] = accumulator;
	// addr: 1DB	opcodes: 75 2B 10
	RAM[0x2B] = 0x10;
label_1DE:	// addr: 1DE	opcodes: D2 8C
	bitSet(TCON, bit4);
label_1E0:	// addr: 1E0	opcodes: D0 83
	// Warning: POP 0x83 not implemented Yet!
	// addr: 1E2	opcodes: D0 82
	// Warning: POP 0x82 not implemented Yet!
	// addr: 1E4	opcodes: D0 F0
	// Warning: POP 0xF0 not implemented Yet!
	// addr: 1E6	opcodes: D0 E0
	// Warning: POP 0xE0 not implemented Yet!
	// addr: 1E8	opcodes: D0 D0
	// Warning: POP 0xD0 not implemented Yet!
	// addr: 1EA	opcodes: 32
	return; // return form IRQ (opcode: 0x32)
label_1EB:	// addr: 1EB	opcodes: E5 2B
	accumulator = RAM[0x2B];
	// addr: 1ED	opcodes: 14
	accumulator--;
	// addr: 1EE	opcodes: F5 2B
	RAM[0x2B] = accumulator;
	// addr: 1F0	opcodes: 60 02
	if ( accumulator == 0 ) goto label_1F4;
	// addr: 1F2	opcodes: 80 EA
	goto label_1DE;
label_1F4:	// addr: 1F4	opcodes: C2 A9
	bitClear(IntEnable, bit1);
	// addr: 1F6	opcodes: 12 08 12
	label_812(); // long call
	// addr: 1F9	opcodes: 80 E5
	goto label_1E0;
label_1FB:	// addr: 1FB	opcodes: D2 34
	bitSet(RAM[0x26], bit4);
	// addr: 1FD	opcodes: 32
	return; // return form IRQ (opcode: 0x32)
label_1FE:	// addr: 1FE	opcodes: E5 34
	accumulator = RAM[0x34];
	// addr: 200	opcodes: 60 05
	if ( accumulator == 0 ) goto label_207;
	// addr: 202	opcodes: 90 17 86
	DPTR = 0x1786;
	// addr: 205	opcodes: 80 03
	goto label_20A;
label_207:	// addr: 207	opcodes: 90 17 50
	DPTR = 0x1750;
label_20A:	// addr: 20A	opcodes: E5 82
	accumulator = RAM[0x82];
	// addr: 20C	opcodes: C3
	carry = false; // clear carry
	// addr: 20D	opcodes: 34 30
	// Warning: ADDC a, #data, flags not fully implemented
accumulator += carry ? 1 : 0;	// carry affected!
accumulator += 0x30;	// carry affected!
	// addr: 20F	opcodes: F5 82
	RAM[0x82] = accumulator;
	// addr: 211	opcodes: E0
	accumulator = extRAM[DPTR];	// external RAM
	// addr: 212	opcodes: F5 47
	RAM[0x47] = accumulator;
	// addr: 214	opcodes: A3
	DPTR++;
	// addr: 215	opcodes: A3
	DPTR++;
	// addr: 216	opcodes: E0
	accumulator = extRAM[DPTR];	// external RAM
	// addr: 217	opcodes: F5 3B
	RAM[0x3B] = accumulator;
	// addr: 219	opcodes: A3
	DPTR++;
	// addr: 21A	opcodes: A3
	DPTR++;
	// addr: 21B	opcodes: E0
	accumulator = extRAM[DPTR];	// external RAM
	// addr: 21C	opcodes: F5 4B
	RAM[0x4B] = accumulator;
	// addr: 21E	opcodes: A3
	DPTR++;
	// addr: 21F	opcodes: E0
	accumulator = extRAM[DPTR];	// external RAM
	// addr: 220	opcodes: F5 48
	RAM[0x48] = accumulator;
	// addr: 222	opcodes: 75 29 00
	RAM[0x29] = 0x00;
	// addr: 225	opcodes: 22
	return; // return (opcode: 0x22)
label_226:	// addr: 226	opcodes: C2 A9
	bitClear(IntEnable, bit1);
	// addr: 228	opcodes: C2 8C
	bitClear(TCON, bit4);
	// addr: 22A	opcodes: 75 27 00
	RAM[0x27] = 0x00;
	// addr: 22D	opcodes: 75 41 00
	RAM[0x41] = 0x00;
	// addr: 230	opcodes: 31 FE
	label_1FE(); // absolute call
	// addr: 232	opcodes: 12 07 B9
	label_7B9(); // long call
	// addr: 235	opcodes: E5 3A
	accumulator = RAM[0x3A];
	// addr: 237	opcodes: B4 04 0A
	if (accumulator != 0x04) goto label_244;
	// addr: 23A	opcodes: E5 27
	accumulator = RAM[0x27];
	// addr: 23C	opcodes: B4 6A 05
	if (accumulator != 0x6A) goto label_244;
	// addr: 23F	opcodes: 75 27 00
	RAM[0x27] = 0x00;
	// addr: 242	opcodes: 80 04
	goto label_248;
label_244:	// addr: 244	opcodes: E5 27
	accumulator = RAM[0x27];
	// addr: 246	opcodes: 70 5E
	if ( accumulator != 0 ) goto label_2A6;
label_248:	// addr: 248	opcodes: 74 02
	accumulator = 0x02;
	// addr: 24A	opcodes: C3
	carry = false; // clear carry
	// addr: 24B	opcodes: 95 37
	// Warning: SUBB a, data addr, flags not fully implemented
accumulator -= carry ? 1 : 0;	// carry affected!
accumulator -= RAM[0x37];	// carry affected!
	// addr: 24D	opcodes: 40 54
	if ( carry ) goto label_2A3;
	// addr: 24F	opcodes: 70 09
	if ( accumulator != 0 ) goto label_25A;
	// addr: 251	opcodes: AA 38
	R2 = RAM[0x38];
	// addr: 253	opcodes: 74 D0
	accumulator = 0xD0;
	// addr: 255	opcodes: C3
	carry = false; // clear carry
	// addr: 256	opcodes: 95 38
	// Warning: SUBB a, data addr, flags not fully implemented
accumulator -= carry ? 1 : 0;	// carry affected!
accumulator -= RAM[0x38];	// carry affected!
	// addr: 258	opcodes: 40 49
	if ( carry ) goto label_2A3;
label_25A:	// addr: 25A	opcodes: 12 02 B3
	label_2B3(); // long call
	// addr: 25D	opcodes: 75 42 06
	RAM[0x42] = 0x06;
label_260:	// addr: 260	opcodes: 12 03 36
	label_336(); // long call
	// addr: 263	opcodes: E5 27
	accumulator = RAM[0x27];
	// addr: 265	opcodes: 60 08
	if ( accumulator == 0 ) goto label_26F;
	// addr: 267	opcodes: E5 3A
	accumulator = RAM[0x3A];
	// addr: 269	opcodes: B4 05 03
	if (accumulator != 0x05) goto label_26F;
	// addr: 26C	opcodes: 02 02 A6
	goto label_2A6; // long jump
label_26F:	// addr: 26F	opcodes: 12 03 6B
	label_36B(); // long call
	// addr: 272	opcodes: E5 27
	accumulator = RAM[0x27];
	// addr: 274	opcodes: 60 30
	if ( accumulator == 0 ) goto label_2A6;
	// addr: 276	opcodes: E5 3A
	accumulator = RAM[0x3A];
	// addr: 278	opcodes: B4 05 08
	if (accumulator != 0x05) goto label_283;
	// addr: 27B	opcodes: E5 27
	accumulator = RAM[0x27];
	// addr: 27D	opcodes: B4 6A 03
	if (accumulator != 0x6A) goto label_283;
	// addr: 280	opcodes: 02 02 A6
	goto label_2A6; // long jump
label_283:	// addr: 283	opcodes: E5 27
	accumulator = RAM[0x27];
	// addr: 285	opcodes: FE
	R6 = accumulator;
	// addr: 286	opcodes: 75 27 00
	RAM[0x27] = 0x00;
	// addr: 289	opcodes: 15 42
	RAM[0x42]--;
	// addr: 28B	opcodes: E5 42
	accumulator = RAM[0x42];
	// addr: 28D	opcodes: 60 0F
	if ( accumulator == 0 ) goto label_29E;
	// addr: 28F	opcodes: E5 42
	accumulator = RAM[0x42];
	// addr: 291	opcodes: B4 03 CC
	if (accumulator != 0x03) goto label_260;
	// addr: 294	opcodes: 12 08 3B
	label_83B(); // long call
	// addr: 297	opcodes: E5 27
	accumulator = RAM[0x27];
	// addr: 299	opcodes: B4 6B C4
	if (accumulator != 0x6B) goto label_260;
	// addr: 29C	opcodes: 80 08
	goto label_2A6;
label_29E:	// addr: 29E	opcodes: EE
	accumulator = R6;
	// addr: 29F	opcodes: F5 27
	RAM[0x27] = accumulator;
	// addr: 2A1	opcodes: 80 03
	goto label_2A6;
label_2A3:	// addr: 2A3	opcodes: 75 27 66
	RAM[0x27] = 0x66;
label_2A6:	// addr: 2A6	opcodes: E5 3A
	accumulator = RAM[0x3A];
	// addr: 2A8	opcodes: B4 05 04
	if (accumulator != 0x05) goto label_2AF;
	// addr: 2AB	opcodes: 12 09 61
	label_961(); // long call
	// addr: 2AE	opcodes: 22
	return; // return (opcode: 0x22)
label_2AF:	// addr: 2AF	opcodes: 12 09 D1
	label_9D1(); // long call
	// addr: 2B2	opcodes: 22
	return; // return (opcode: 0x22)
label_2B3:	// addr: 2B3	opcodes: E5 37
	accumulator = RAM[0x37];
	// addr: 2B5	opcodes: 60 43
	if ( accumulator == 0 ) goto label_2FA;
	// addr: 2B7	opcodes: 7B 00
	R3 = 0x00;
	// addr: 2B9	opcodes: 75 30 10
	RAM[0x30] = 0x10;
	// addr: 2BC	opcodes: E5 47
	accumulator = RAM[0x47];
	// addr: 2BE	opcodes: C0 E0
	// Warning: PUSH 0xE0 not implemented Yet!
	// addr: 2C0	opcodes: C3
	carry = false; // clear carry
	// addr: 2C1	opcodes: 85 3B F0
	RAM[0xF0] = RAM[0x3B];
	// addr: 2C4	opcodes: A4
	tmp16 = (uint16_t)accumulator * (uint16_t)regB;
accumulator = (uint8_t) ( (uint16_t)tmp16 & 0xFF) ;
regB = (uint8_t) ( ((uint16_t)tmp16 >> 8) & 0xFF) ;
	// addr: 2C5	opcodes: F5 47
	RAM[0x47] = accumulator;
	// addr: 2C7	opcodes: AC 38
	R4 = RAM[0x38];
	// addr: 2C9	opcodes: AD 37
	R5 = RAM[0x37];
label_2CB:	// addr: 2CB	opcodes: C3
	carry = false; // clear carry
	// addr: 2CC	opcodes: EB
	accumulator = R3;
	// addr: 2CD	opcodes: 33
	if (bitRead(accumulator, 7)) tmpCarry = true;
accumulator = accumulator << 1;
if (tmpCarry) bitSet(accumulator, 0);
carry = tmpCarry;
	// addr: 2CE	opcodes: FB
	R3 = accumulator;
	// addr: 2CF	opcodes: EC
	accumulator = R4;
	// addr: 2D0	opcodes: C3
	carry = false; // clear carry
	// addr: 2D1	opcodes: 33
	if (bitRead(accumulator, 7)) tmpCarry = true;
accumulator = accumulator << 1;
if (tmpCarry) bitSet(accumulator, 0);
carry = tmpCarry;
	// addr: 2D2	opcodes: FC
	R4 = accumulator;
	// addr: 2D3	opcodes: ED
	accumulator = R5;
	// addr: 2D4	opcodes: 33
	if (bitRead(accumulator, 7)) tmpCarry = true;
accumulator = accumulator << 1;
if (tmpCarry) bitSet(accumulator, 0);
carry = tmpCarry;
	// addr: 2D5	opcodes: FD
	R5 = accumulator;
	// addr: 2D6	opcodes: 74 00
	accumulator = 0x00;
	// addr: 2D8	opcodes: 3B
	// Warning: ADDC a, Rr, flags not fully implemented
accumulator += carry ? 1 : 0;	// carry affected!
accumulator += R3;	// carry affected!
	// addr: 2D9	opcodes: FB
	R3 = accumulator;
	// addr: 2DA	opcodes: C3
	carry = false; // clear carry
	// addr: 2DB	opcodes: 95 47
	// Warning: SUBB a, data addr, flags not fully implemented
accumulator -= carry ? 1 : 0;	// carry affected!
accumulator -= RAM[0x47];	// carry affected!
	// addr: 2DD	opcodes: 40 04
	if ( carry ) goto label_2E3;
	// addr: 2DF	opcodes: FB
	R3 = accumulator;
	// addr: 2E0	opcodes: EC
	accumulator = R4;
	// addr: 2E1	opcodes: 04
	accumulator++;
	// addr: 2E2	opcodes: FC
	R4 = accumulator;
label_2E3:	// addr: 2E3	opcodes: D5 30 E5
	RAM[0x30]--;
if (RAM[0x30] == 0) goto label_2CB;
	// addr: 2E6	opcodes: EC
	accumulator = R4;
	// addr: 2E7	opcodes: F5 3C
	RAM[0x3C] = accumulator;
	// addr: 2E9	opcodes: EB
	accumulator = R3;
	// addr: 2EA	opcodes: F5 3E
	RAM[0x3E] = accumulator;
	// addr: 2EC	opcodes: E5 47
	accumulator = RAM[0x47];
	// addr: 2EE	opcodes: F5 F0
	RAM[0xF0] = accumulator;
	// addr: 2F0	opcodes: D0 E0
	// Warning: POP 0xE0 not implemented Yet!
	// addr: 2F2	opcodes: F5 47
	RAM[0x47] = accumulator;
	// addr: 2F4	opcodes: E5 F0
	accumulator = RAM[0xF0];
	// addr: 2F6	opcodes: C0 E0
	// Warning: PUSH 0xE0 not implemented Yet!
	// addr: 2F8	opcodes: 80 14
	goto label_30E;
label_2FA:	// addr: 2FA	opcodes: C3
	carry = false; // clear carry
	// addr: 2FB	opcodes: 85 3B F0
	RAM[0xF0] = RAM[0x3B];
	// addr: 2FE	opcodes: E5 47
	accumulator = RAM[0x47];
	// addr: 300	opcodes: A4
	tmp16 = (uint16_t)accumulator * (uint16_t)regB;
accumulator = (uint8_t) ( (uint16_t)tmp16 & 0xFF) ;
regB = (uint8_t) ( ((uint16_t)tmp16 >> 8) & 0xFF) ;
	// addr: 301	opcodes: C0 E0
	// Warning: PUSH 0xE0 not implemented Yet!
	// addr: 303	opcodes: F5 F0
	RAM[0xF0] = accumulator;
	// addr: 305	opcodes: E5 38
	accumulator = RAM[0x38];
	// addr: 307	opcodes: C3
	carry = false; // clear carry
	// addr: 308	opcodes: 84
	// Warning: // DIV AB, Flags not implemented!
accumulator = accumulator / regB;
regB = accumulator % regB;
	// addr: 309	opcodes: F5 3C
	RAM[0x3C] = accumulator;
	// addr: 30B	opcodes: 85 F0 3E
	RAM[0x3E] = RAM[0xF0];
label_30E:	// addr: 30E	opcodes: E5 3B
	accumulator = RAM[0x3B];
	// addr: 310	opcodes: 14
	accumulator--;
	// addr: 311	opcodes: 60 15
	if ( accumulator == 0 ) goto label_328;
	// addr: 313	opcodes: E5 3E
	accumulator = RAM[0x3E];
	// addr: 315	opcodes: C3
	carry = false; // clear carry
	// addr: 316	opcodes: 95 47
	// Warning: SUBB a, data addr, flags not fully implemented
accumulator -= carry ? 1 : 0;	// carry affected!
accumulator -= RAM[0x47];	// carry affected!
	// addr: 318	opcodes: 40 0E
	if ( carry ) goto label_328;
	// addr: 31A	opcodes: 75 29 02
	RAM[0x29] = 0x02;
	// addr: 31D	opcodes: E5 48
	accumulator = RAM[0x48];
	// addr: 31F	opcodes: 70 07
	if ( accumulator != 0 ) goto label_328;
	// addr: 321	opcodes: C3
	carry = false; // clear carry
	// addr: 322	opcodes: E5 3E
	accumulator = RAM[0x3E];
	// addr: 324	opcodes: 95 47
	// Warning: SUBB a, data addr, flags not fully implemented
accumulator -= carry ? 1 : 0;	// carry affected!
accumulator -= RAM[0x47];	// carry affected!
	// addr: 326	opcodes: F5 3E
	RAM[0x3E] = accumulator;
label_328:	// addr: 328	opcodes: D0 E0
	// Warning: POP 0xE0 not implemented Yet!
	// addr: 32A	opcodes: C3
	carry = false; // clear carry
	// addr: 32B	opcodes: 95 3E
	// Warning: SUBB a, data addr, flags not fully implemented
accumulator -= carry ? 1 : 0;	// carry affected!
accumulator -= RAM[0x3E];	// carry affected!
	// addr: 32D	opcodes: 70 04
	if ( accumulator != 0 ) goto label_333;
	// addr: 32F	opcodes: 05 3C
	RAM[0x3C]++;
	// addr: 331	opcodes: F5 3E
	RAM[0x3E] = accumulator;
label_333:	// addr: 333	opcodes: 05 3E
	RAM[0x3E]++;
	// addr: 335	opcodes: 22
	return; // return (opcode: 0x22)
label_336:	// addr: 336	opcodes: E5 4C
	accumulator = RAM[0x4C];
	// addr: 338	opcodes: B4 FF 04
	if (accumulator != 0xFF) goto label_33F;
	// addr: 33B	opcodes: 75 27 00
	RAM[0x27] = 0x00;
	// addr: 33E	opcodes: 22
	return; // return (opcode: 0x22)
label_33F:	// addr: 33F	opcodes: C3
	carry = false; // clear carry
	// addr: 340	opcodes: E5 4C
	accumulator = RAM[0x4C];
	// addr: 342	opcodes: 95 3C
	// Warning: SUBB a, data addr, flags not fully implemented
accumulator -= carry ? 1 : 0;	// carry affected!
accumulator -= RAM[0x3C];	// carry affected!
	// addr: 344	opcodes: 40 0D
	if ( carry ) goto label_353;
	// addr: 346	opcodes: 60 01
	if ( accumulator == 0 ) goto label_349;
	// addr: 348	opcodes: 22
	return; // return (opcode: 0x22)
label_349:	// addr: 349	opcodes: C3
	carry = false; // clear carry
	// addr: 34A	opcodes: E5 4E
	accumulator = RAM[0x4E];
	// addr: 34C	opcodes: 95 3E
	// Warning: SUBB a, data addr, flags not fully implemented
accumulator -= carry ? 1 : 0;	// carry affected!
accumulator -= RAM[0x3E];	// carry affected!
	// addr: 34E	opcodes: 40 03
	if ( carry ) goto label_353;
	// addr: 350	opcodes: 60 01
	if ( accumulator == 0 ) goto label_353;
	// addr: 352	opcodes: 22
	return; // return (opcode: 0x22)
label_353:	// addr: 353	opcodes: C3
	carry = false; // clear carry
	// addr: 354	opcodes: E5 3C
	accumulator = RAM[0x3C];
	// addr: 356	opcodes: 95 2D
	// Warning: SUBB a, data addr, flags not fully implemented
accumulator -= carry ? 1 : 0;	// carry affected!
accumulator -= RAM[0x2D];	// carry affected!
	// addr: 358	opcodes: 40 03
	if ( carry ) goto label_35D;
	// addr: 35A	opcodes: 60 01
	if ( accumulator == 0 ) goto label_35D;
	// addr: 35C	opcodes: 22
	return; // return (opcode: 0x22)
label_35D:	// addr: 35D	opcodes: C3
	carry = false; // clear carry
	// addr: 35E	opcodes: E5 3E
	accumulator = RAM[0x3E];
	// addr: 360	opcodes: 95 2C
	// Warning: SUBB a, data addr, flags not fully implemented
accumulator -= carry ? 1 : 0;	// carry affected!
accumulator -= RAM[0x2C];	// carry affected!
	// addr: 362	opcodes: 40 03
	if ( carry ) goto label_367;
	// addr: 364	opcodes: 60 01
	if ( accumulator == 0 ) goto label_367;
	// addr: 366	opcodes: 22
	return; // return (opcode: 0x22)
label_367:	// addr: 367	opcodes: 75 27 6A
	RAM[0x27] = 0x6A;
	// addr: 36A	opcodes: 22
	return; // return (opcode: 0x22)
label_36B:	// addr: 36B	opcodes: C2 A9
	bitClear(IntEnable, bit1);
	// addr: 36D	opcodes: C2 8C
	bitClear(TCON, bit4);
	// addr: 36F	opcodes: 12 07 0D
	label_70D(); // long call
	// addr: 372	opcodes: 90 24 00
	DPTR = 0x2400;
	// addr: 375	opcodes: E0
	accumulator = extRAM[DPTR];	// external RAM
	// addr: 376	opcodes: B5 3C 1D
	if (accumulator != RAM[0x3C]) goto label_396;
	// addr: 379	opcodes: E5 27
	accumulator = RAM[0x27];
	// addr: 37B	opcodes: 60 25
	if ( accumulator == 0 ) goto label_3A2;
	// addr: 37D	opcodes: B4 6B 01
	if (accumulator != 0x6B) goto label_381;
	// addr: 380	opcodes: 22
	return; // return (opcode: 0x22)
label_381:	// addr: 381	opcodes: 30 3E 0F
	if (bitRead(RAM[0x27], bit6) == false) goto label_393;
	// addr: 384	opcodes: E5 3A
	accumulator = RAM[0x3A];
	// addr: 386	opcodes: B4 04 05
	if (accumulator != 0x04) goto label_38E;
	// addr: 389	opcodes: 75 27 00
	RAM[0x27] = 0x00;
	// addr: 38C	opcodes: 80 14
	goto label_3A2;
label_38E:	// addr: 38E	opcodes: 75 27 6A
	RAM[0x27] = 0x6A;
	// addr: 391	opcodes: 80 0B
	goto label_39E;
label_393:	// addr: 393	opcodes: 30 3C 05
	if (bitRead(RAM[0x27], bit4) == false) goto label_39B;
label_396:	// addr: 396	opcodes: 75 27 68
	RAM[0x27] = 0x68;
	// addr: 399	opcodes: 80 03
	goto label_39E;
label_39B:	// addr: 39B	opcodes: 75 27 67
	RAM[0x27] = 0x67;
label_39E:	// addr: 39E	opcodes: 12 08 3B
	label_83B(); // long call
	// addr: 3A1	opcodes: 22
	return; // return (opcode: 0x22)
label_3A2:	// addr: 3A2	opcodes: E5 3E
	accumulator = RAM[0x3E];
	// addr: 3A4	opcodes: 90 28 00
	DPTR = 0x2800;
	// addr: 3A7	opcodes: F0
	extRAM[DPTR] = accumulator;	// external RAM
	// addr: 3A8	opcodes: E5 3A
	accumulator = RAM[0x3A];
	// addr: 3AA	opcodes: B4 04 0C
	if (accumulator != 0x04) goto label_3B9;
	// addr: 3AD	opcodes: 91 5D
	label_45D(); // absolute call
	// addr: 3AF	opcodes: E5 27
	accumulator = RAM[0x27];
	// addr: 3B1	opcodes: B4 6B 01
	if (accumulator != 0x6B) goto label_3B5;
	// addr: 3B4	opcodes: 22
	return; // return (opcode: 0x22)
label_3B5:	// addr: 3B5	opcodes: 54 1C
	accumulator &= 0x1C;
	// addr: 3B7	opcodes: 80 0A
	goto label_3C3;
label_3B9:	// addr: 3B9	opcodes: 91 09
	label_409(); // absolute call
	// addr: 3BB	opcodes: E5 27
	accumulator = RAM[0x27];
	// addr: 3BD	opcodes: B4 6B 01
	if (accumulator != 0x6B) goto label_3C1;
	// addr: 3C0	opcodes: 22
	return; // return (opcode: 0x22)
label_3C1:	// addr: 3C1	opcodes: 54 7C
	accumulator &= 0x7C;
label_3C3:	// addr: 3C3	opcodes: 70 02
	if ( accumulator != 0 ) goto label_3C7;
	// addr: 3C5	opcodes: 80 1F
	goto label_3E6;
label_3C7:	// addr: 3C7	opcodes: 30 3E 04
	if (bitRead(RAM[0x27], bit6) == false) goto label_3CE;
	// addr: 3CA	opcodes: 75 27 6A
	RAM[0x27] = 0x6A;
	// addr: 3CD	opcodes: 22
	return; // return (opcode: 0x22)
label_3CE:	// addr: 3CE	opcodes: 30 3D 04
	if (bitRead(RAM[0x27], bit5) == false) goto label_3D5;
	// addr: 3D1	opcodes: 75 27 6C
	RAM[0x27] = 0x6C;
	// addr: 3D4	opcodes: 22
	return; // return (opcode: 0x22)
label_3D5:	// addr: 3D5	opcodes: 30 3C 04
	if (bitRead(RAM[0x27], bit4) == false) goto label_3DC;
	// addr: 3D8	opcodes: 75 27 68
	RAM[0x27] = 0x68;
	// addr: 3DB	opcodes: 22
	return; // return (opcode: 0x22)
label_3DC:	// addr: 3DC	opcodes: 30 3B 04
	if (bitRead(RAM[0x27], bit3) == false) goto label_3E3;
	// addr: 3DF	opcodes: 75 27 67
	RAM[0x27] = 0x67;
	// addr: 3E2	opcodes: 22
	return; // return (opcode: 0x22)
label_3E3:	// addr: 3E3	opcodes: 75 27 6C
	RAM[0x27] = 0x6C;
label_3E6:	// addr: 3E6	opcodes: 22
	return; // return (opcode: 0x22)
label_3E7:	// addr: 3E7	opcodes: C2 8C
	bitClear(TCON, bit4);
	// addr: 3E9	opcodes: C2 A9
	bitClear(IntEnable, bit1);
	// addr: 3EB	opcodes: 75 30 00
	RAM[0x30] = 0x00;
	// addr: 3EE	opcodes: 78 FF
	R0 = 0xFF;
	// addr: 3F0	opcodes: D2 91
	bitSet(Port1, bit1);
	// addr: 3F2	opcodes: 75 A0 11
	RAM[0xA0] = 0x11;
	// addr: 3F5	opcodes: 75 89 01
	RAM[0x89] = 0x01;
	// addr: 3F8	opcodes: 75 8C 00
	RAM[0x8C] = 0x00;
	// addr: 3FB	opcodes: 75 8A 00
	RAM[0x8A] = 0x00;
	// addr: 3FE	opcodes: C2 8C
	bitClear(TCON, bit4);
	// addr: 400	opcodes: 74 D0
	accumulator = 0xD0;
	// addr: 402	opcodes: 90 20 00
	DPTR = 0x2000;
	// addr: 405	opcodes: F0
	extRAM[DPTR] = accumulator;	// external RAM
	// addr: 406	opcodes: F1 B2
	label_7B2(); // absolute call
	// addr: 408	opcodes: 22
	return; // return (opcode: 0x22)
label_409:	// addr: 409	opcodes: 71 E7
	label_3E7(); // absolute call
	// addr: 40B	opcodes: 74 A8
	accumulator = 0xA8;
	// addr: 40D	opcodes: 45 29
	accumulator |= RAM[0x29];
	// addr: 40F	opcodes: 44 04
	accumulator |= 0x04;
	// addr: 411	opcodes: 75 31 14
	RAM[0x31] = 0x14;
	// addr: 414	opcodes: D2 30
	bitSet(RAM[0x26], bit0);
	// addr: 416	opcodes: 90 20 00
	DPTR = 0x2000;
	// addr: 419	opcodes: F0
	extRAM[DPTR] = accumulator;	// external RAM
	// addr: 41A	opcodes: 90 2C 00
	DPTR = 0x2C00;
	// addr: 41D	opcodes: D2 8C
	bitSet(TCON, bit4);
label_41F:	// addr: 41F	opcodes: 20 91 0F
	if (bitRead(Port1, bit1) == true) goto label_431;
	// addr: 422	opcodes: 30 8D FA
	if (bitRead(TCON, bit5) == false) goto label_41F;
	// addr: 425	opcodes: 75 88 04
	RAM[0x88] = 0x04;
	// addr: 428	opcodes: D2 8C
	bitSet(TCON, bit4);
	// addr: 42A	opcodes: D5 31 F2
	RAM[0x31]--;
if (RAM[0x31] == 0) goto label_41F;
	// addr: 42D	opcodes: 12 07 32
	label_732(); // long call
	// addr: 430	opcodes: 22
	return; // return (opcode: 0x22)
label_431:	// addr: 431	opcodes: C2 8C
	bitClear(TCON, bit4);
	// addr: 433	opcodes: 75 8C 00
	RAM[0x8C] = 0x00;
	// addr: 436	opcodes: 75 8A 00
	RAM[0x8A] = 0x00;
	// addr: 439	opcodes: D2 8C
	bitSet(TCON, bit4);
label_43B:	// addr: 43B	opcodes: 20 91 05
	if (bitRead(Port1, bit1) == true) goto label_443;
	// addr: 43E	opcodes: 30 8D FA
	if (bitRead(TCON, bit5) == false) goto label_43B;
	// addr: 441	opcodes: 80 16
	goto label_459;
label_443:	// addr: 443	opcodes: E2
	accumulator = extRAM[R0];	// external RAM
	// addr: 444	opcodes: F0
	extRAM[DPTR] = accumulator;	// external RAM
	// addr: 445	opcodes: 18
	R0--;
	// addr: 446	opcodes: D5 30 F2
	RAM[0x30]--;
if (RAM[0x30] == 0) goto label_43B;
	// addr: 449	opcodes: 15 A0
	RAM[0xA0]--;
label_44B:	// addr: 44B	opcodes: 20 91 05
	if (bitRead(Port1, bit1) == true) goto label_453;
	// addr: 44E	opcodes: 30 8D FA
	if (bitRead(TCON, bit5) == false) goto label_44B;
	// addr: 451	opcodes: 80 06
	goto label_459;
label_453:	// addr: 453	opcodes: E2
	accumulator = extRAM[R0];	// external RAM
	// addr: 454	opcodes: F0
	extRAM[DPTR] = accumulator;	// external RAM
	// addr: 455	opcodes: 18
	R0--;
	// addr: 456	opcodes: D5 30 F2
	RAM[0x30]--;
if (RAM[0x30] == 0) goto label_44B;
label_459:	// addr: 459	opcodes: 12 07 67
	label_767(); // long call
	// addr: 45C	opcodes: 22
	return; // return (opcode: 0x22)
label_45D:	// addr: 45D	opcodes: 71 E7
	label_3E7(); // absolute call
	// addr: 45F	opcodes: 74 88
	accumulator = 0x88;
	// addr: 461	opcodes: 45 29
	accumulator |= RAM[0x29];
	// addr: 463	opcodes: 44 04
	accumulator |= 0x04;
	// addr: 465	opcodes: 75 31 14
	RAM[0x31] = 0x14;
	// addr: 468	opcodes: D2 30
	bitSet(RAM[0x26], bit0);
	// addr: 46A	opcodes: 90 20 00
	DPTR = 0x2000;
	// addr: 46D	opcodes: F0
	extRAM[DPTR] = accumulator;	// external RAM
	// addr: 46E	opcodes: 90 2C 00
	DPTR = 0x2C00;
	// addr: 471	opcodes: D2 8C
	bitSet(TCON, bit4);
label_473:	// addr: 473	opcodes: 20 91 0F
	if (bitRead(Port1, bit1) == true) goto label_485;
	// addr: 476	opcodes: 30 8D FA
	if (bitRead(TCON, bit5) == false) goto label_473;
	// addr: 479	opcodes: 75 88 04
	RAM[0x88] = 0x04;
	// addr: 47C	opcodes: D2 8C
	bitSet(TCON, bit4);
	// addr: 47E	opcodes: D5 31 F2
	RAM[0x31]--;
if (RAM[0x31] == 0) goto label_473;
	// addr: 481	opcodes: 12 07 32
	label_732(); // long call
	// addr: 484	opcodes: 22
	return; // return (opcode: 0x22)
label_485:	// addr: 485	opcodes: C2 8C
	bitClear(TCON, bit4);
	// addr: 487	opcodes: 75 8C 00
	RAM[0x8C] = 0x00;
	// addr: 48A	opcodes: 75 8A 00
	RAM[0x8A] = 0x00;
	// addr: 48D	opcodes: D2 8C
	bitSet(TCON, bit4);
label_48F:	// addr: 48F	opcodes: 20 91 05
	if (bitRead(Port1, bit1) == true) goto label_497;
	// addr: 492	opcodes: 30 8D FA
	if (bitRead(TCON, bit5) == false) goto label_48F;
	// addr: 495	opcodes: 80 16
	goto label_4AD;
label_497:	// addr: 497	opcodes: E0
	accumulator = extRAM[DPTR];	// external RAM
	// addr: 498	opcodes: F2
	extRAM[R0] = accumulator;	// external RAM
	// addr: 499	opcodes: 18
	R0--;
	// addr: 49A	opcodes: D5 30 F2
	RAM[0x30]--;
if (RAM[0x30] == 0) goto label_48F;
	// addr: 49D	opcodes: 15 A0
	RAM[0xA0]--;
label_49F:	// addr: 49F	opcodes: 20 91 05
	if (bitRead(Port1, bit1) == true) goto label_4A7;
	// addr: 4A2	opcodes: 30 8D FA
	if (bitRead(TCON, bit5) == false) goto label_49F;
	// addr: 4A5	opcodes: 80 06
	goto label_4AD;
label_4A7:	// addr: 4A7	opcodes: E0
	accumulator = extRAM[DPTR];	// external RAM
	// addr: 4A8	opcodes: F2
	extRAM[R0] = accumulator;	// external RAM
	// addr: 4A9	opcodes: 18
	R0--;
	// addr: 4AA	opcodes: D5 30 F2
	RAM[0x30]--;
if (RAM[0x30] == 0) goto label_49F;
label_4AD:	// addr: 4AD	opcodes: F1 67
	label_767(); // absolute call
	// addr: 4AF	opcodes: 78 FF
	R0 = 0xFF;
	// addr: 4B1	opcodes: 79 01
	R1 = 0x01;
	// addr: 4B3	opcodes: 22
	return; // return (opcode: 0x22)
label_4B4:	// addr: 4B4	opcodes: 75 27 00
	RAM[0x27] = 0x00;
	// addr: 4B7	opcodes: 75 41 00
	RAM[0x41] = 0x00;
	// addr: 4BA	opcodes: 31 FE
	label_1FE(); // absolute call
	// addr: 4BC	opcodes: F1 B9
	label_7B9(); // absolute call
	// addr: 4BE	opcodes: E5 27
	accumulator = RAM[0x27];
	// addr: 4C0	opcodes: 70 38
	if ( accumulator != 0 ) goto label_4FA;
label_4C2:	// addr: 4C2	opcodes: E5 3A
	accumulator = RAM[0x3A];
	// addr: 4C4	opcodes: B4 16 04
	if (accumulator != 0x16) goto label_4CB;
	// addr: 4C7	opcodes: 51 B3
	label_2B3(); // absolute call
	// addr: 4C9	opcodes: 81 CE
	goto label_4CE; // absolute jump
label_4CB:	// addr: 4CB	opcodes: 75 3C 00
	RAM[0x3C] = 0x00;
label_4CE:	// addr: 4CE	opcodes: D1 01
	label_601(); // absolute call
	// addr: 4D0	opcodes: F1 0D
	label_70D(); // absolute call
	// addr: 4D2	opcodes: E5 27
	accumulator = RAM[0x27];
	// addr: 4D4	opcodes: 70 2D
	if ( accumulator != 0 ) goto label_503;
	// addr: 4D6	opcodes: 90 20 00
	DPTR = 0x2000;
	// addr: 4D9	opcodes: E0
	accumulator = extRAM[DPTR];	// external RAM
	// addr: 4DA	opcodes: 54 D8
	accumulator &= 0xD8;
	// addr: 4DC	opcodes: 70 20
	if ( accumulator != 0 ) goto label_4FE;
	// addr: 4DE	opcodes: B1 08
	label_508(); // absolute call
	// addr: 4E0	opcodes: E5 27
	accumulator = RAM[0x27];
	// addr: 4E2	opcodes: 70 19
	if ( accumulator != 0 ) goto label_4FD;
	// addr: 4E4	opcodes: E5 3A
	accumulator = RAM[0x3A];
	// addr: 4E6	opcodes: B4 11 11
	if (accumulator != 0x11) goto label_4FA;
	// addr: 4E9	opcodes: 05 3C
	RAM[0x3C]++;
	// addr: 4EB	opcodes: E5 3C
	accumulator = RAM[0x3C];
	// addr: 4ED	opcodes: B4 28 DE
	if (accumulator != 0x28) goto label_4CE;
	// addr: 4F0	opcodes: E5 29
	accumulator = RAM[0x29];
	// addr: 4F2	opcodes: 04
	accumulator++;
	// addr: 4F3	opcodes: F5 29
	RAM[0x29] = accumulator;
	// addr: 4F5	opcodes: C3
	carry = false; // clear carry
	// addr: 4F6	opcodes: 95 3B
	// Warning: SUBB a, data addr, flags not fully implemented
accumulator -= carry ? 1 : 0;	// carry affected!
accumulator -= RAM[0x3B];	// carry affected!
	// addr: 4F8	opcodes: 70 C8
	if ( accumulator != 0 ) goto label_4C2;
label_4FA:	// addr: 4FA	opcodes: 12 07 67
	label_767(); // long call
label_4FD:	// addr: 4FD	opcodes: 22
	return; // return (opcode: 0x22)
label_4FE:	// addr: 4FE	opcodes: 75 27 6A
	RAM[0x27] = 0x6A;
	// addr: 501	opcodes: 80 FA
	goto label_4FD;
label_503:	// addr: 503	opcodes: 75 27 66
	RAM[0x27] = 0x66;
	// addr: 506	opcodes: 80 F5
	goto label_4FD;
label_508:	// addr: 508	opcodes: C2 A9
	bitClear(IntEnable, bit1);
	// addr: 50A	opcodes: E5 47
	accumulator = RAM[0x47];
	// addr: 50C	opcodes: F5 3E
	RAM[0x3E] = accumulator;
	// addr: 50E	opcodes: 78 00
	R0 = 0x00;
	// addr: 510	opcodes: 79 3B
	R1 = 0x3B;
	// addr: 512	opcodes: 75 30 14
	RAM[0x30] = 0x14;
	// addr: 515	opcodes: 75 31 00
	RAM[0x31] = 0x00;
	// addr: 518	opcodes: 75 32 08
	RAM[0x32] = 0x08;
	// addr: 51B	opcodes: 75 33 1D
	RAM[0x33] = 0x1D;
	// addr: 51E	opcodes: 75 89 01
	RAM[0x89] = 0x01;
	// addr: 521	opcodes: 75 8C 00
	RAM[0x8C] = 0x00;
	// addr: 524	opcodes: 75 8A 00
	RAM[0x8A] = 0x00;
	// addr: 527	opcodes: C2 8C
	bitClear(TCON, bit4);
	// addr: 529	opcodes: 74 D0
	accumulator = 0xD0;
	// addr: 52B	opcodes: D2 91
	bitSet(Port1, bit1);
	// addr: 52D	opcodes: D2 30
	bitSet(RAM[0x26], bit0);
	// addr: 52F	opcodes: 90 20 00
	DPTR = 0x2000;
	// addr: 532	opcodes: F0
	extRAM[DPTR] = accumulator;	// external RAM
	// addr: 533	opcodes: F1 B2
	label_7B2(); // absolute call
	// addr: 535	opcodes: 74 F4
	accumulator = 0xF4;
	// addr: 537	opcodes: C0 E0
	// Warning: PUSH 0xE0 not implemented Yet!
	// addr: 539	opcodes: E5 29
	accumulator = RAM[0x29];
	// addr: 53B	opcodes: 60 06
	if ( accumulator == 0 ) goto label_543;
	// addr: 53D	opcodes: D0 E0
	// Warning: POP 0xE0 not implemented Yet!
	// addr: 53F	opcodes: 44 02
	accumulator |= 0x02;
	// addr: 541	opcodes: C0 E0
	// Warning: PUSH 0xE0 not implemented Yet!
label_543:	// addr: 543	opcodes: D0 E0
	// Warning: POP 0xE0 not implemented Yet!
	// addr: 545	opcodes: D2 30
	bitSet(RAM[0x26], bit0);
	// addr: 547	opcodes: 90 20 00
	DPTR = 0x2000;
	// addr: 54A	opcodes: F0
	extRAM[DPTR] = accumulator;	// external RAM
	// addr: 54B	opcodes: 90 2C 00
	DPTR = 0x2C00;
	// addr: 54E	opcodes: D2 8C
	bitSet(TCON, bit4);
label_550:	// addr: 550	opcodes: 20 91 0F
	if (bitRead(Port1, bit1) == true) goto label_562;
	// addr: 553	opcodes: 30 8D FA
	if (bitRead(TCON, bit5) == false) goto label_550;
	// addr: 556	opcodes: 75 88 04
	RAM[0x88] = 0x04;
	// addr: 559	opcodes: D2 8C
	bitSet(TCON, bit4);
	// addr: 55B	opcodes: D5 30 F2
	RAM[0x30]--;
if (RAM[0x30] == 0) goto label_550;
	// addr: 55E	opcodes: 12 07 32
	label_732(); // long call
	// addr: 561	opcodes: 22
	return; // return (opcode: 0x22)
label_562:	// addr: 562	opcodes: C2 8C
	bitClear(TCON, bit4);
	// addr: 564	opcodes: 75 30 50
	RAM[0x30] = 0x50;
	// addr: 567	opcodes: 74 4E
	accumulator = 0x4E;
label_569:	// addr: 569	opcodes: 30 91 FD
	if (bitRead(Port1, bit1) == false) goto label_569;
	// addr: 56C	opcodes: F0
	extRAM[DPTR] = accumulator;	// external RAM
	// addr: 56D	opcodes: D5 30 F9
	RAM[0x30]--;
if (RAM[0x30] == 0) goto label_569;
	// addr: 570	opcodes: 74 F6
	accumulator = 0xF6;
	// addr: 572	opcodes: 75 30 03
	RAM[0x30] = 0x03;
label_575:	// addr: 575	opcodes: 30 91 FD
	if (bitRead(Port1, bit1) == false) goto label_575;
	// addr: 578	opcodes: F0
	extRAM[DPTR] = accumulator;	// external RAM
	// addr: 579	opcodes: D5 30 F9
	RAM[0x30]--;
if (RAM[0x30] == 0) goto label_575;
	// addr: 57C	opcodes: 74 FC
	accumulator = 0xFC;
label_57E:	// addr: 57E	opcodes: 30 91 FD
	if (bitRead(Port1, bit1) == false) goto label_57E;
	// addr: 581	opcodes: F0
	extRAM[DPTR] = accumulator;	// external RAM
	// addr: 582	opcodes: 75 30 32
	RAM[0x30] = 0x32;
	// addr: 585	opcodes: 74 4E
	accumulator = 0x4E;
label_587:	// addr: 587	opcodes: 30 91 FD
	if (bitRead(Port1, bit1) == false) goto label_587;
	// addr: 58A	opcodes: F0
	extRAM[DPTR] = accumulator;	// external RAM
	// addr: 58B	opcodes: D5 30 F9
	RAM[0x30]--;
if (RAM[0x30] == 0) goto label_587;
	// addr: 58E	opcodes: 75 A0 10
	RAM[0xA0] = 0x10;
label_591:	// addr: 591	opcodes: 79 3B
	R1 = 0x3B;
label_593:	// addr: 593	opcodes: 30 91 FD
	if (bitRead(Port1, bit1) == false) goto label_593;
	// addr: 596	opcodes: E2
	accumulator = extRAM[R0];	// external RAM
	// addr: 597	opcodes: F0
	extRAM[DPTR] = accumulator;	// external RAM
	// addr: 598	opcodes: 08
	R0++;
	// addr: 599	opcodes: B8 00 02
	if (RAM[R0] != 0x00) goto label_59E;
	// addr: 59C	opcodes: 05 A0
	RAM[0xA0]++;
label_59E:	// addr: 59E	opcodes: D9 F3
	R1--;
if (R1 != 0) goto label_593;
	// addr: 5A0	opcodes: 74 FF
	accumulator = 0xFF;
label_5A2:	// addr: 5A2	opcodes: 30 91 FD
	if (bitRead(Port1, bit1) == false) goto label_5A2;
	// addr: 5A5	opcodes: F0
	extRAM[DPTR] = accumulator;	// external RAM
	// addr: 5A6	opcodes: D5 32 F9
	RAM[0x32]--;
if (RAM[0x32] == 0) goto label_5A2;
	// addr: 5A9	opcodes: 74 E5
	accumulator = 0xE5;
label_5AB:	// addr: 5AB	opcodes: 30 91 FD
	if (bitRead(Port1, bit1) == false) goto label_5AB;
	// addr: 5AE	opcodes: F0
	extRAM[DPTR] = accumulator;	// external RAM
	// addr: 5AF	opcodes: D5 31 F9
	RAM[0x31]--;
if (RAM[0x31] == 0) goto label_5AB;
	// addr: 5B2	opcodes: 75 31 F8
	RAM[0x31] = 0xF8;
label_5B5:	// addr: 5B5	opcodes: 30 91 FD
	if (bitRead(Port1, bit1) == false) goto label_5B5;
	// addr: 5B8	opcodes: F0
	extRAM[DPTR] = accumulator;	// external RAM
	// addr: 5B9	opcodes: D5 31 F9
	RAM[0x31]--;
if (RAM[0x31] == 0) goto label_5B5;
	// addr: 5BC	opcodes: 75 33 1D
	RAM[0x33] = 0x1D;
	// addr: 5BF	opcodes: 75 31 00
	RAM[0x31] = 0x00;
	// addr: 5C2	opcodes: 75 32 08
	RAM[0x32] = 0x08;
label_5C5:	// addr: 5C5	opcodes: 30 91 FD
	if (bitRead(Port1, bit1) == false) goto label_5C5;
	// addr: 5C8	opcodes: E2
	accumulator = extRAM[R0];	// external RAM
	// addr: 5C9	opcodes: F0
	extRAM[DPTR] = accumulator;	// external RAM
	// addr: 5CA	opcodes: 08
	R0++;
	// addr: 5CB	opcodes: B8 00 02
	if (RAM[R0] != 0x00) goto label_5D0;
	// addr: 5CE	opcodes: 05 A0
	RAM[0xA0]++;
label_5D0:	// addr: 5D0	opcodes: D5 33 F2
	RAM[0x33]--;
if (RAM[0x33] == 0) goto label_5C5;
	// addr: 5D3	opcodes: D5 3E BB
	RAM[0x3E]--;
if (RAM[0x3E] == 0) goto label_591;
	// addr: 5D6	opcodes: D2 8C
	bitSet(TCON, bit4);
	// addr: 5D8	opcodes: 75 30 0A
	RAM[0x30] = 0x0A;
label_5DB:	// addr: 5DB	opcodes: 30 91 17
	if (bitRead(Port1, bit1) == false) goto label_5F5;
	// addr: 5DE	opcodes: 30 8D 0C
	if (bitRead(TCON, bit5) == false) goto label_5ED;
	// addr: 5E1	opcodes: 75 88 04
	RAM[0x88] = 0x04;
	// addr: 5E4	opcodes: D2 8C
	bitSet(TCON, bit4);
	// addr: 5E6	opcodes: D5 30 04
	RAM[0x30]--;
if (RAM[0x30] == 0) goto label_5ED;
	// addr: 5E9	opcodes: 75 27 6B
	RAM[0x27] = 0x6B;
	// addr: 5EC	opcodes: 22
	return; // return (opcode: 0x22)
label_5ED:	// addr: 5ED	opcodes: 90 2C 00
	DPTR = 0x2C00;
	// addr: 5F0	opcodes: 74 00
	accumulator = 0x00;
	// addr: 5F2	opcodes: F0
	extRAM[DPTR] = accumulator;	// external RAM
	// addr: 5F3	opcodes: 80 E6
	goto label_5DB;
label_5F5:	// addr: 5F5	opcodes: 90 20 00
	DPTR = 0x2000;
	// addr: 5F8	opcodes: E0
	accumulator = extRAM[DPTR];	// external RAM
	// addr: 5F9	opcodes: F5 28
	RAM[0x28] = accumulator;
	// addr: 5FB	opcodes: 20 40 DD
	if (bitRead(RAM[0x28], bit0) == true) goto label_5DB;
	// addr: 5FE	opcodes: F5 27
	RAM[0x27] = accumulator;
	// addr: 600	opcodes: 22
	return; // return (opcode: 0x22)
label_601:	// addr: 601	opcodes: D1 8C
	label_68C(); // absolute call
	// addr: 603	opcodes: E5 47
	accumulator = RAM[0x47];
	// addr: 605	opcodes: F5 3E
	RAM[0x3E] = accumulator;
	// addr: 607	opcodes: 75 3F 00
	RAM[0x3F] = 0x00;
	// addr: 60A	opcodes: 90 10 00
	DPTR = 0x1000;
label_60D:	// addr: 60D	opcodes: 75 30 0C
	RAM[0x30] = 0x0C;
	// addr: 610	opcodes: 74 00
	accumulator = 0x00;
label_612:	// addr: 612	opcodes: F0
	extRAM[DPTR] = accumulator;	// external RAM
	// addr: 613	opcodes: A3
	DPTR++;
	// addr: 614	opcodes: D5 30 FB
	RAM[0x30]--;
if (RAM[0x30] == 0) goto label_612;
	// addr: 617	opcodes: 75 30 03
	RAM[0x30] = 0x03;
	// addr: 61A	opcodes: 74 F5
	accumulator = 0xF5;
label_61C:	// addr: 61C	opcodes: F0
	extRAM[DPTR] = accumulator;	// external RAM
	// addr: 61D	opcodes: A3
	DPTR++;
	// addr: 61E	opcodes: D5 30 FB
	RAM[0x30]--;
if (RAM[0x30] == 0) goto label_61C;
	// addr: 621	opcodes: 74 FE
	accumulator = 0xFE;
	// addr: 623	opcodes: F0
	extRAM[DPTR] = accumulator;	// external RAM
	// addr: 624	opcodes: A3
	DPTR++;
	// addr: 625	opcodes: E5 3C
	accumulator = RAM[0x3C];
	// addr: 627	opcodes: F0
	extRAM[DPTR] = accumulator;	// external RAM
	// addr: 628	opcodes: A3
	DPTR++;
	// addr: 629	opcodes: E5 29
	accumulator = RAM[0x29];
	// addr: 62B	opcodes: F0
	extRAM[DPTR] = accumulator;	// external RAM
	// addr: 62C	opcodes: 12 06 70
	label_670(); // long call
	// addr: 62F	opcodes: A3
	DPTR++;
	// addr: 630	opcodes: E5 40
	accumulator = RAM[0x40];
	// addr: 632	opcodes: F0
	extRAM[DPTR] = accumulator;	// external RAM
	// addr: 633	opcodes: A3
	DPTR++;
	// addr: 634	opcodes: 74 02
	accumulator = 0x02;
	// addr: 636	opcodes: F0
	extRAM[DPTR] = accumulator;	// external RAM
	// addr: 637	opcodes: A3
	DPTR++;
	// addr: 638	opcodes: 74 F7
	accumulator = 0xF7;
	// addr: 63A	opcodes: F0
	extRAM[DPTR] = accumulator;	// external RAM
	// addr: 63B	opcodes: 75 30 16
	RAM[0x30] = 0x16;
	// addr: 63E	opcodes: 74 4E
	accumulator = 0x4E;
	// addr: 640	opcodes: A3
	DPTR++;
label_641:	// addr: 641	opcodes: F0
	extRAM[DPTR] = accumulator;	// external RAM
	// addr: 642	opcodes: A3
	DPTR++;
	// addr: 643	opcodes: D5 30 FB
	RAM[0x30]--;
if (RAM[0x30] == 0) goto label_641;
	// addr: 646	opcodes: 75 30 0C
	RAM[0x30] = 0x0C;
	// addr: 649	opcodes: 74 00
	accumulator = 0x00;
label_64B:	// addr: 64B	opcodes: F0
	extRAM[DPTR] = accumulator;	// external RAM
	// addr: 64C	opcodes: A3
	DPTR++;
	// addr: 64D	opcodes: D5 30 FB
	RAM[0x30]--;
if (RAM[0x30] == 0) goto label_64B;
	// addr: 650	opcodes: 75 30 03
	RAM[0x30] = 0x03;
	// addr: 653	opcodes: 74 F5
	accumulator = 0xF5;
label_655:	// addr: 655	opcodes: F0
	extRAM[DPTR] = accumulator;	// external RAM
	// addr: 656	opcodes: A3
	DPTR++;
	// addr: 657	opcodes: D5 30 FB
	RAM[0x30]--;
if (RAM[0x30] == 0) goto label_655;
	// addr: 65A	opcodes: 74 FB
	accumulator = 0xFB;
	// addr: 65C	opcodes: F0
	extRAM[DPTR] = accumulator;	// external RAM
	// addr: 65D	opcodes: A3
	DPTR++;
	// addr: 65E	opcodes: 74 F7
	accumulator = 0xF7;
	// addr: 660	opcodes: F0
	extRAM[DPTR] = accumulator;	// external RAM
	// addr: 661	opcodes: A3
	DPTR++;
	// addr: 662	opcodes: 75 30 1C
	RAM[0x30] = 0x1C;
	// addr: 665	opcodes: 74 4E
	accumulator = 0x4E;
label_667:	// addr: 667	opcodes: F0
	extRAM[DPTR] = accumulator;	// external RAM
	// addr: 668	opcodes: A3
	DPTR++;
	// addr: 669	opcodes: D5 30 FB
	RAM[0x30]--;
if (RAM[0x30] == 0) goto label_667;
	// addr: 66C	opcodes: D5 3E 9E
	RAM[0x3E]--;
if (RAM[0x3E] == 0) goto label_60D;
	// addr: 66F	opcodes: 22
	return; // return (opcode: 0x22)
label_670:	// addr: 670	opcodes: C0 E0
	// Warning: PUSH 0xE0 not implemented Yet!
	// addr: 672	opcodes: C0 82
	// Warning: PUSH 0x82 not implemented Yet!
	// addr: 674	opcodes: C0 83
	// Warning: PUSH 0x83 not implemented Yet!
	// addr: 676	opcodes: 90 17 BC
	DPTR = 0x17BC;
	// addr: 679	opcodes: C3
	carry = false; // clear carry
	// addr: 67A	opcodes: E5 82
	accumulator = RAM[0x82];
	// addr: 67C	opcodes: 35 3F
	// Warning: ADDC a, data addr, flags not fully implemented
accumulator += carry ? 1 : 0;	// carry affected!
accumulator += RAM[0x3F];	// carry affected!
	// addr: 67E	opcodes: F5 82
	RAM[0x82] = accumulator;
	// addr: 680	opcodes: E0
	accumulator = extRAM[DPTR];	// external RAM
	// addr: 681	opcodes: F5 40
	RAM[0x40] = accumulator;
	// addr: 683	opcodes: 05 3F
	RAM[0x3F]++;
	// addr: 685	opcodes: D0 83
	// Warning: POP 0x83 not implemented Yet!
	// addr: 687	opcodes: D0 82
	// Warning: POP 0x82 not implemented Yet!
	// addr: 689	opcodes: D0 E0
	// Warning: POP 0xE0 not implemented Yet!
	// addr: 68B	opcodes: 22
	return; // return (opcode: 0x22)
label_68C:	// addr: 68C	opcodes: 75 30 40
	RAM[0x30] = 0x40;
	// addr: 68F	opcodes: 90 17 BC
	DPTR = 0x17BC;
label_692:	// addr: 692	opcodes: 74 00
	accumulator = 0x00;
	// addr: 694	opcodes: F0
	extRAM[DPTR] = accumulator;	// external RAM
	// addr: 695	opcodes: A3
	DPTR++;
	// addr: 696	opcodes: D5 30 F9
	RAM[0x30]--;
if (RAM[0x30] == 0) goto label_692;
	// addr: 699	opcodes: E5 29
	accumulator = RAM[0x29];
	// addr: 69B	opcodes: C0 E0
	// Warning: PUSH 0xE0 not implemented Yet!
	// addr: 69D	opcodes: 31 FE
	label_1FE(); // absolute call
	// addr: 69F	opcodes: D0 E0
	// Warning: POP 0xE0 not implemented Yet!
	// addr: 6A1	opcodes: F5 29
	RAM[0x29] = accumulator;
	// addr: 6A3	opcodes: 75 49 00
	RAM[0x49] = 0x00;
	// addr: 6A6	opcodes: 90 17 BC
	DPTR = 0x17BC;
	// addr: 6A9	opcodes: E5 29
	accumulator = RAM[0x29];
	// addr: 6AB	opcodes: 60 08
	if ( accumulator == 0 ) goto label_6B5;
	// addr: 6AD	opcodes: E5 48
	accumulator = RAM[0x48];
	// addr: 6AF	opcodes: 60 04
	if ( accumulator == 0 ) goto label_6B5;
	// addr: 6B1	opcodes: E5 47
	accumulator = RAM[0x47];
	// addr: 6B3	opcodes: F5 49
	RAM[0x49] = accumulator;
label_6B5:	// addr: 6B5	opcodes: E5 47
	accumulator = RAM[0x47];
	// addr: 6B7	opcodes: F0
	extRAM[DPTR] = accumulator;	// external RAM
	// addr: 6B8	opcodes: 05 49
	RAM[0x49]++;
	// addr: 6BA	opcodes: 05 49
	RAM[0x49]++;
	// addr: 6BC	opcodes: 75 4A 02
	RAM[0x4A] = 0x02;
label_6BF:	// addr: 6BF	opcodes: E5 49
	accumulator = RAM[0x49];
	// addr: 6C1	opcodes: 14
	accumulator--;
	// addr: 6C2	opcodes: 85 4B F0
	RAM[0xF0] = RAM[0x4B];
	// addr: 6C5	opcodes: A4
	tmp16 = (uint16_t)accumulator * (uint16_t)regB;
accumulator = (uint8_t) ( (uint16_t)tmp16 & 0xFF) ;
regB = (uint8_t) ( ((uint16_t)tmp16 >> 8) & 0xFF) ;
	// addr: 6C6	opcodes: C0 E0
	// Warning: PUSH 0xE0 not implemented Yet!
	// addr: 6C8	opcodes: 90 17 BC
	DPTR = 0x17BC;
	// addr: 6CB	opcodes: E0
	accumulator = extRAM[DPTR];	// external RAM
	// addr: 6CC	opcodes: F5 F0
	RAM[0xF0] = accumulator;
	// addr: 6CE	opcodes: D0 E0
	// Warning: POP 0xE0 not implemented Yet!
	// addr: 6D0	opcodes: 84
	// Warning: // DIV AB, Flags not implemented!
accumulator = accumulator / regB;
regB = accumulator % regB;
	// addr: 6D1	opcodes: E5 F0
	accumulator = RAM[0xF0];
	// addr: 6D3	opcodes: F5 30
	RAM[0x30] = accumulator;
	// addr: 6D5	opcodes: 60 04
	if ( accumulator == 0 ) goto label_6DB;
label_6D7:	// addr: 6D7	opcodes: A3
	DPTR++;
	// addr: 6D8	opcodes: D5 30 FC
	RAM[0x30]--;
if (RAM[0x30] == 0) goto label_6D7;
label_6DB:	// addr: 6DB	opcodes: E0
	accumulator = extRAM[DPTR];	// external RAM
	// addr: 6DC	opcodes: B4 00 12
	if (accumulator != 0x00) goto label_6F1;
	// addr: 6DF	opcodes: E5 49
	accumulator = RAM[0x49];
	// addr: 6E1	opcodes: F0
	extRAM[DPTR] = accumulator;	// external RAM
	// addr: 6E2	opcodes: 05 4A
	RAM[0x4A]++;
	// addr: 6E4	opcodes: 05 49
	RAM[0x49]++;
	// addr: 6E6	opcodes: E5 4A
	accumulator = RAM[0x4A];
	// addr: 6E8	opcodes: C3
	carry = false; // clear carry
	// addr: 6E9	opcodes: 95 47
	// Warning: SUBB a, data addr, flags not fully implemented
accumulator -= carry ? 1 : 0;	// carry affected!
accumulator -= RAM[0x47];	// carry affected!
	// addr: 6EB	opcodes: 40 D2
	if ( carry ) goto label_6BF;
	// addr: 6ED	opcodes: 60 D0
	if ( accumulator == 0 ) goto label_6BF;
	// addr: 6EF	opcodes: C1 F4
	goto label_6F4; // absolute jump
label_6F1:	// addr: 6F1	opcodes: A3
	DPTR++;
	// addr: 6F2	opcodes: C1 DB
	goto label_6DB; // absolute jump
label_6F4:	// addr: 6F4	opcodes: 75 49 01
	RAM[0x49] = 0x01;
	// addr: 6F7	opcodes: E5 29
	accumulator = RAM[0x29];
	// addr: 6F9	opcodes: 60 0B
	if ( accumulator == 0 ) goto label_706;
	// addr: 6FB	opcodes: E5 48
	accumulator = RAM[0x48];
	// addr: 6FD	opcodes: 60 07
	if ( accumulator == 0 ) goto label_706;
	// addr: 6FF	opcodes: C3
	carry = false; // clear carry
	// addr: 700	opcodes: E5 49
	accumulator = RAM[0x49];
	// addr: 702	opcodes: 35 47
	// Warning: ADDC a, data addr, flags not fully implemented
accumulator += carry ? 1 : 0;	// carry affected!
accumulator += RAM[0x47];	// carry affected!
	// addr: 704	opcodes: F5 49
	RAM[0x49] = accumulator;
label_706:	// addr: 706	opcodes: 90 17 BC
	DPTR = 0x17BC;
	// addr: 709	opcodes: E5 49
	accumulator = RAM[0x49];
	// addr: 70B	opcodes: F0
	extRAM[DPTR] = accumulator;	// external RAM
	// addr: 70C	opcodes: 22
	return; // return (opcode: 0x22)
label_70D:	// addr: 70D	opcodes: C2 B1
	bitClear(Port3, bit1);
	// addr: 70F	opcodes: C3
	carry = false; // clear carry
	// addr: 710	opcodes: E5 3C
	accumulator = RAM[0x3C];
	// addr: 712	opcodes: 94 1E
	// Warning: SUBB a, #data, flags not fully implemented
accumulator -= carry ? 1 : 0;	// carry affected!
accumulator -= 0x1E;	// carry affected!
	// addr: 714	opcodes: 60 04
	if ( accumulator == 0 ) goto label_71A;
	// addr: 716	opcodes: 40 02
	if ( carry ) goto label_71A;
	// addr: 718	opcodes: D2 B1
	bitSet(Port3, bit1);
label_71A:	// addr: 71A	opcodes: E5 3C
	accumulator = RAM[0x3C];
	// addr: 71C	opcodes: 90 2C 00
	DPTR = 0x2C00;
	// addr: 71F	opcodes: F0
	extRAM[DPTR] = accumulator;	// external RAM
	// addr: 720	opcodes: 75 3D 18
	RAM[0x3D] = 0x18;
	// addr: 723	opcodes: F1 9C
	label_79C(); // absolute call
	// addr: 725	opcodes: F1 45
	label_745(); // absolute call
	// addr: 727	opcodes: E5 27
	accumulator = RAM[0x27];
	// addr: 729	opcodes: B4 6B 01
	if (accumulator != 0x6B) goto label_72D;
	// addr: 72C	opcodes: 22
	return; // return (opcode: 0x22)
label_72D:	// addr: 72D	opcodes: 54 58
	accumulator &= 0x58;
	// addr: 72F	opcodes: F5 27
	RAM[0x27] = accumulator;
	// addr: 731	opcodes: 22
	return; // return (opcode: 0x22)
label_732:	// addr: 732	opcodes: 90 20 00
	DPTR = 0x2000;
	// addr: 735	opcodes: E0
	accumulator = extRAM[DPTR];	// external RAM
	// addr: 736	opcodes: F5 27
	RAM[0x27] = accumulator;
	// addr: 738	opcodes: 30 3C 03
	if (bitRead(RAM[0x27], bit4) == false) goto label_73E;
	// addr: 73B	opcodes: 02 07 41
	goto label_741; // long jump
label_73E:	// addr: 73E	opcodes: 75 27 6B
	RAM[0x27] = 0x6B;
label_741:	// addr: 741	opcodes: 12 07 7A
	label_77A(); // long call
	// addr: 744	opcodes: 22
	return; // return (opcode: 0x22)
label_745:	// addr: 745	opcodes: 75 31 10
	RAM[0x31] = 0x10;
	// addr: 748	opcodes: 75 89 01
	RAM[0x89] = 0x01;
label_74B:	// addr: 74B	opcodes: 75 88 04
	RAM[0x88] = 0x04;
	// addr: 74E	opcodes: 75 8C 00
	RAM[0x8C] = 0x00;
	// addr: 751	opcodes: 75 8A 00
	RAM[0x8A] = 0x00;
	// addr: 754	opcodes: D2 8C
	bitSet(TCON, bit4);
label_756:	// addr: 756	opcodes: 30 8D 08
	if (bitRead(TCON, bit5) == false) goto label_761;
	// addr: 759	opcodes: D5 31 EF
	RAM[0x31]--;
if (RAM[0x31] == 0) goto label_74B;
	// addr: 75C	opcodes: 75 27 6B
	RAM[0x27] = 0x6B;
	// addr: 75F	opcodes: 80 19
	goto label_77A;
label_761:	// addr: 761	opcodes: A2 30
	if (bitRead(RAM[0x26], bit0) == true) {
	carry = true;
	} else {
		carry = false;
	};
	// addr: 763	opcodes: 40 F1
	if ( carry ) goto label_756;
	// addr: 765	opcodes: 80 04
	goto label_76B;
label_767:	// addr: 767	opcodes: A2 30
	if (bitRead(RAM[0x26], bit0) == true) {
	carry = true;
	} else {
		carry = false;
	};
	// addr: 769	opcodes: 40 FC
	if ( carry ) goto label_767;
label_76B:	// addr: 76B	opcodes: E5 27
	accumulator = RAM[0x27];
	// addr: 76D	opcodes: C0 E0
	// Warning: PUSH 0xE0 not implemented Yet!
	// addr: 76F	opcodes: 90 20 00
	DPTR = 0x2000;
	// addr: 772	opcodes: E0
	accumulator = extRAM[DPTR];	// external RAM
	// addr: 773	opcodes: F5 27
	RAM[0x27] = accumulator;
	// addr: 775	opcodes: D0 E0
	// Warning: POP 0xE0 not implemented Yet!
	// addr: 777	opcodes: B5 27 1C
	if (accumulator != RAM[0x27]) goto label_796;
label_77A:	// addr: 77A	opcodes: 90 20 00
	DPTR = 0x2000;
	// addr: 77D	opcodes: 74 D6
	accumulator = 0xD6;
	// addr: 77F	opcodes: F0
	extRAM[DPTR] = accumulator;	// external RAM
	// addr: 780	opcodes: F1 B2
	label_7B2(); // absolute call
	// addr: 782	opcodes: 75 8C 00
	RAM[0x8C] = 0x00;
	// addr: 785	opcodes: 75 8A 00
	RAM[0x8A] = 0x00;
	// addr: 788	opcodes: 75 89 01
	RAM[0x89] = 0x01;
	// addr: 78B	opcodes: 75 2B 00
	RAM[0x2B] = 0x00;
	// addr: 78E	opcodes: 75 2A 00
	RAM[0x2A] = 0x00;
	// addr: 791	opcodes: D2 8C
	bitSet(TCON, bit4);
	// addr: 793	opcodes: D2 A9
	bitSet(IntEnable, bit1);
	// addr: 795	opcodes: 22
	return; // return (opcode: 0x22)
label_796:	// addr: 796	opcodes: 60 E2
	if ( accumulator == 0 ) goto label_77A;
	// addr: 798	opcodes: F5 27
	RAM[0x27] = accumulator;
	// addr: 79A	opcodes: E1 7A
	goto label_77A; // absolute jump
label_79C:	// addr: 79C	opcodes: C2 AF
	bitClear(IntEnable, bit7);
	// addr: 79E	opcodes: 90 20 00
	DPTR = 0x2000;
	// addr: 7A1	opcodes: 74 D2
	accumulator = 0xD2;
	// addr: 7A3	opcodes: F0
	extRAM[DPTR] = accumulator;	// external RAM
	// addr: 7A4	opcodes: F1 B2
	label_7B2(); // absolute call
	// addr: 7A6	opcodes: D2 30
	bitSet(RAM[0x26], bit0);
	// addr: 7A8	opcodes: 7F 32
	R7 = 0x32;
	// addr: 7AA	opcodes: D2 AF
	bitSet(IntEnable, bit7);
	// addr: 7AC	opcodes: E5 3D
	accumulator = RAM[0x3D];
	// addr: 7AE	opcodes: F0
	extRAM[DPTR] = accumulator;	// external RAM
	// addr: 7AF	opcodes: F1 B2
	label_7B2(); // absolute call
	// addr: 7B1	opcodes: 22
	return; // return (opcode: 0x22)
label_7B2:	// addr: 7B2	opcodes: 75 39 0C
	RAM[0x39] = 0x0C;
label_7B5:	// addr: 7B5	opcodes: D5 39 FD
	RAM[0x39]--;
if (RAM[0x39] == 0) goto label_7B5;
	// addr: 7B8	opcodes: 22
	return; // return (opcode: 0x22)
label_7B9:	// addr: 7B9	opcodes: C2 A9
	bitClear(IntEnable, bit1);
	// addr: 7BB	opcodes: C2 8C
	bitClear(TCON, bit4);
	// addr: 7BD	opcodes: E5 34
	accumulator = RAM[0x34];
	// addr: 7BF	opcodes: 60 0B
	if ( accumulator == 0 ) goto label_7CC;
	// addr: 7C1	opcodes: 20 B2 11
	if (bitRead(Port3, bit2) == true) goto label_7D5;
	// addr: 7C4	opcodes: C2 B4
	bitClear(Port3, bit4);
	// addr: 7C6	opcodes: C2 36
	bitClear(RAM[0x26], bit6);
	// addr: 7C8	opcodes: C2 32
	bitClear(RAM[0x26], bit2);
	// addr: 7CA	opcodes: 80 09
	goto label_7D5;
label_7CC:	// addr: 7CC	opcodes: 20 B4 06
	if (bitRead(Port3, bit4) == true) goto label_7D5;
	// addr: 7CF	opcodes: C2 B2
	bitClear(Port3, bit2);
	// addr: 7D1	opcodes: C2 36
	bitClear(RAM[0x26], bit6);
	// addr: 7D3	opcodes: C2 32
	bitClear(RAM[0x26], bit2);
label_7D5:	// addr: 7D5	opcodes: A2 36
	if (bitRead(RAM[0x26], bit6) == true) {
	carry = true;
	} else {
		carry = false;
	};
	// addr: 7D7	opcodes: 50 02
	if ( carry == false ) goto label_7DB;
	// addr: 7D9	opcodes: 80 12
	goto label_7ED;
label_7DB:	// addr: 7DB	opcodes: D2 36
	bitSet(RAM[0x26], bit6);
	// addr: 7DD	opcodes: E5 34
	accumulator = RAM[0x34];
	// addr: 7DF	opcodes: 70 04
	if ( accumulator != 0 ) goto label_7E5;
	// addr: 7E1	opcodes: D2 B4
	bitSet(Port3, bit4);
	// addr: 7E3	opcodes: 80 02
	goto label_7E7;
label_7E5:	// addr: 7E5	opcodes: D2 B2
	bitSet(Port3, bit2);
label_7E7:	// addr: 7E7	opcodes: 75 31 8C
	RAM[0x31] = 0x8C;
	// addr: 7EA	opcodes: 12 08 02
	label_802(); // long call
label_7ED:	// addr: 7ED	opcodes: A2 32
	if (bitRead(RAM[0x26], bit2) == true) {
	carry = true;
	} else {
		carry = false;
	};
	// addr: 7EF	opcodes: 50 03
	if ( carry == false ) goto label_7F4;
	// addr: 7F1	opcodes: 7F 32
	R7 = 0x32;
	// addr: 7F3	opcodes: 22
	return; // return (opcode: 0x22)
label_7F4:	// addr: 7F4	opcodes: D2 B0
	bitSet(Port3, bit0);
	// addr: 7F6	opcodes: D2 32
	bitSet(RAM[0x26], bit2);
	// addr: 7F8	opcodes: 75 31 46
	RAM[0x31] = 0x46;
	// addr: 7FB	opcodes: 12 08 02
	label_802(); // long call
	// addr: 7FE	opcodes: 12 08 3B
	label_83B(); // long call
	// addr: 801	opcodes: 22
	return; // return (opcode: 0x22)
label_802:	// addr: 802	opcodes: 75 30 FF
	RAM[0x30] = 0xFF;
label_805:	// addr: 805	opcodes: 12 07 B2
	label_7B2(); // long call
	// addr: 808	opcodes: D5 30 FA
	RAM[0x30]--;
if (RAM[0x30] == 0) goto label_805;
	// addr: 80B	opcodes: 75 30 FF
	RAM[0x30] = 0xFF;
	// addr: 80E	opcodes: D5 31 F4
	RAM[0x31]--;
if (RAM[0x31] == 0) goto label_805;
	// addr: 811	opcodes: 22
	return; // return (opcode: 0x22)
label_812:	// addr: 812	opcodes: 90 20 00
	DPTR = 0x2000;
	// addr: 815	opcodes: 74 D0
	accumulator = 0xD0;
	// addr: 817	opcodes: F0
	extRAM[DPTR] = accumulator;	// external RAM
	// addr: 818	opcodes: C2 8C
	bitClear(TCON, bit4);
	// addr: 81A	opcodes: C2 A9
	bitClear(IntEnable, bit1);
	// addr: 81C	opcodes: C2 32
	bitClear(RAM[0x26], bit2);
	// addr: 81E	opcodes: C2 B0
	bitClear(Port3, bit0);
label_820:	// addr: 820	opcodes: C2 36
	bitClear(RAM[0x26], bit6);
	// addr: 822	opcodes: C2 B4
	bitClear(Port3, bit4);
	// addr: 824	opcodes: C2 B2
	bitClear(Port3, bit2);
	// addr: 826	opcodes: 22
	return; // return (opcode: 0x22)
label_827:	// addr: 827	opcodes: C2 B1
	bitClear(Port3, bit1);
	// addr: 829	opcodes: 75 3D 00
	RAM[0x3D] = 0x00;
	// addr: 82C	opcodes: 12 07 9C
	label_79C(); // long call
	// addr: 82F	opcodes: 12 07 45
	label_745(); // long call
	// addr: 832	opcodes: E5 27
	accumulator = RAM[0x27];
	// addr: 834	opcodes: 54 58
	accumulator &= 0x58;
	// addr: 836	opcodes: F5 27
	RAM[0x27] = accumulator;
	// addr: 838	opcodes: 02 08 59
	goto label_859; // long jump
label_83B:	// addr: 83B	opcodes: 11 27
	label_827(); // absolute call
	// addr: 83D	opcodes: 60 1A
	if ( accumulator == 0 ) goto label_859;
	// addr: 83F	opcodes: 30 3E 0A
	if (bitRead(RAM[0x27], bit6) == false) goto label_84C;
	// addr: 842	opcodes: 75 27 6A
	RAM[0x27] = 0x6A;
	// addr: 845	opcodes: E5 3A
	accumulator = RAM[0x3A];
	// addr: 847	opcodes: B4 04 0F
	if (accumulator != 0x04) goto label_859;
	// addr: 84A	opcodes: 80 0D
	goto label_859;
label_84C:	// addr: 84C	opcodes: 30 3C 05
	if (bitRead(RAM[0x27], bit4) == false) goto label_854;
	// addr: 84F	opcodes: 75 27 68
	RAM[0x27] = 0x68;
	// addr: 852	opcodes: 80 03
	goto label_857;
label_854:	// addr: 854	opcodes: 75 27 67
	RAM[0x27] = 0x67;
label_857:	// addr: 857	opcodes: 11 12
	label_812(); // absolute call
label_859:	// addr: 859	opcodes: 75 41 00
	RAM[0x41] = 0x00;
	// addr: 85C	opcodes: 22
	return; // return (opcode: 0x22)
label_85D:	// addr: 85D	opcodes: C2 AF
	bitClear(IntEnable, bit7);
label_85F:	// addr: 85F	opcodes: 12 0B 25
	label_B25(); // long call
	// addr: 862	opcodes: 12 0B 33
	label_B33(); // long call
	// addr: 865	opcodes: E5 20
	accumulator = RAM[0x20];
	// addr: 867	opcodes: 54 8D
	accumulator &= 0x8D;
	// addr: 869	opcodes: 60 07
	if ( accumulator == 0 ) goto label_872;
	// addr: 86B	opcodes: 20 07 1B
	if (bitRead(RAM[0x20], bit7) == true) goto label_889;
	// addr: 86E	opcodes: 12 01 17
	label_117(); // long call
	// addr: 871	opcodes: 22
	return; // return (opcode: 0x22)
label_872:	// addr: 872	opcodes: E9
	accumulator = R1;
	// addr: 873	opcodes: 44 10
	accumulator |= 0x10;
	// addr: 875	opcodes: F5 83
	RAM[0x83] = accumulator;
	// addr: 877	opcodes: 88 82
	RAM[0x82] = R0;
	// addr: 879	opcodes: EA
	accumulator = R2;
	// addr: 87A	opcodes: F0
	extRAM[DPTR] = accumulator;	// external RAM
	// addr: 87B	opcodes: D8 03
	R0--;
if (R0 != 0) goto label_880;
	// addr: 87D	opcodes: E9
	accumulator = R1;
	// addr: 87E	opcodes: 70 DF
	if ( accumulator != 0 ) goto label_85F;
label_880:	// addr: 880	opcodes: E8
	accumulator = R0;
	// addr: 881	opcodes: C3
	carry = false; // clear carry
	// addr: 882	opcodes: 94 FF
	// Warning: SUBB a, #data, flags not fully implemented
accumulator -= carry ? 1 : 0;	// carry affected!
accumulator -= 0xFF;	// carry affected!
	// addr: 884	opcodes: 70 D9
	if ( accumulator != 0 ) goto label_85F;
	// addr: 886	opcodes: 19
	R1--;
	// addr: 887	opcodes: 80 D6
	goto label_85F;
label_889:	// addr: 889	opcodes: 75 20 00
	RAM[0x20] = 0x00;
	// addr: 88C	opcodes: 75 83 10
	RAM[0x83] = 0x10;
	// addr: 88F	opcodes: 88 82
	RAM[0x82] = R0;
	// addr: 891	opcodes: EA
	accumulator = R2;
	// addr: 892	opcodes: F0
	extRAM[DPTR] = accumulator;	// external RAM
	// addr: 893	opcodes: 20 28 03
	if (bitRead(RAM[0x25], bit0) == true) goto label_899;
	// addr: 896	opcodes: D2 AF
	bitSet(IntEnable, bit7);
	// addr: 898	opcodes: 22
	return; // return (opcode: 0x22)
label_899:	// addr: 899	opcodes: 90 10 00
	DPTR = 0x1000;
	// addr: 89C	opcodes: 75 82 00
	RAM[0x82] = 0x00;
	// addr: 89F	opcodes: E0
	accumulator = extRAM[DPTR];	// external RAM
	// addr: 8A0	opcodes: F5 43
	RAM[0x43] = accumulator;
	// addr: 8A2	opcodes: A3
	DPTR++;
	// addr: 8A3	opcodes: E0
	accumulator = extRAM[DPTR];	// external RAM
	// addr: 8A4	opcodes: F5 44
	RAM[0x44] = accumulator;
	// addr: 8A6	opcodes: A3
	DPTR++;
	// addr: 8A7	opcodes: E0
	accumulator = extRAM[DPTR];	// external RAM
	// addr: 8A8	opcodes: F5 45
	RAM[0x45] = accumulator;
	// addr: 8AA	opcodes: A3
	DPTR++;
	// addr: 8AB	opcodes: E0
	accumulator = extRAM[DPTR];	// external RAM
	// addr: 8AC	opcodes: F5 35
	RAM[0x35] = accumulator;
	// addr: 8AE	opcodes: A3
	DPTR++;
	// addr: 8AF	opcodes: E0
	accumulator = extRAM[DPTR];	// external RAM
	// addr: 8B0	opcodes: F5 36
	RAM[0x36] = accumulator;
	// addr: 8B2	opcodes: A3
	DPTR++;
	// addr: 8B3	opcodes: E0
	accumulator = extRAM[DPTR];	// external RAM
	// addr: 8B4	opcodes: F5 37
	RAM[0x37] = accumulator;
	// addr: 8B6	opcodes: A3
	DPTR++;
	// addr: 8B7	opcodes: E0
	accumulator = extRAM[DPTR];	// external RAM
	// addr: 8B8	opcodes: F5 38
	RAM[0x38] = accumulator;
	// addr: 8BA	opcodes: A3
	DPTR++;
	// addr: 8BB	opcodes: E0
	accumulator = extRAM[DPTR];	// external RAM
	// addr: 8BC	opcodes: F5 34
	RAM[0x34] = accumulator;
	// addr: 8BE	opcodes: A3
	DPTR++;
	// addr: 8BF	opcodes: A3
	DPTR++;
	// addr: 8C0	opcodes: E0
	accumulator = extRAM[DPTR];	// external RAM
	// addr: 8C1	opcodes: F5 3A
	RAM[0x3A] = accumulator;
	// addr: 8C3	opcodes: D2 AF
	bitSet(IntEnable, bit7);
	// addr: 8C5	opcodes: 22
	return; // return (opcode: 0x22)
label_8C6:	// addr: 8C6	opcodes: E5 3A
	accumulator = RAM[0x3A];
	// addr: 8C8	opcodes: B4 00 21
	if (accumulator != 0x00) goto label_8EC;
	// addr: 8CB	opcodes: E5 34
	accumulator = RAM[0x34];
	// addr: 8CD	opcodes: 60 0D
	if ( accumulator == 0 ) goto label_8DC;
	// addr: 8CF	opcodes: E5 46
	accumulator = RAM[0x46];
	// addr: 8D1	opcodes: B4 01 08
	if (accumulator != 0x01) goto label_8DC;
	// addr: 8D4	opcodes: 75 27 65
	RAM[0x27] = 0x65;
	// addr: 8D7	opcodes: 75 41 00
	RAM[0x41] = 0x00;
	// addr: 8DA	opcodes: 80 03
	goto label_8DF;
label_8DC:	// addr: 8DC	opcodes: 12 01 6F
	label_16F(); // long call
label_8DF:	// addr: 8DF	opcodes: 12 0A B9
	label_AB9(); // long call
	// addr: 8E2	opcodes: 75 21 00
	RAM[0x21] = 0x00;
	// addr: 8E5	opcodes: 75 25 10
	RAM[0x25] = 0x10;
	// addr: 8E8	opcodes: 75 20 00
	RAM[0x20] = 0x00;
	// addr: 8EB	opcodes: 22
	return; // return (opcode: 0x22)
label_8EC:	// addr: 8EC	opcodes: B4 04 08
	if (accumulator != 0x04) goto label_8F7;
	// addr: 8EF	opcodes: 12 02 26
	label_226(); // long call
	// addr: 8F2	opcodes: E5 27
	accumulator = RAM[0x27];
	// addr: 8F4	opcodes: 70 6B
	if ( accumulator != 0 ) goto label_961;
	// addr: 8F6	opcodes: 22
	return; // return (opcode: 0x22)
label_8F7:	// addr: 8F7	opcodes: B4 11 05
	if (accumulator != 0x11) goto label_8FF;
	// addr: 8FA	opcodes: 12 04 B4
	label_4B4(); // long call
	// addr: 8FD	opcodes: 80 62
	goto label_961;
label_8FF:	// addr: 8FF	opcodes: B4 01 09
	if (accumulator != 0x01) goto label_90B;
	// addr: 902	opcodes: 12 09 DB
	label_9DB(); // long call
	// addr: 905	opcodes: 75 21 00
	RAM[0x21] = 0x00;
	// addr: 908	opcodes: C2 31
	bitClear(RAM[0x26], bit1);
	// addr: 90A	opcodes: 22
	return; // return (opcode: 0x22)
label_90B:	// addr: 90B	opcodes: B4 05 23
	if (accumulator != 0x05) goto label_931;
	// addr: 90E	opcodes: E5 43
	accumulator = RAM[0x43];
	// addr: 910	opcodes: B4 00 0B
	if (accumulator != 0x00) goto label_91E;
	// addr: 913	opcodes: 78 FF
	R0 = 0xFF;
	// addr: 915	opcodes: 79 01
	R1 = 0x01;
	// addr: 917	opcodes: 75 21 00
	RAM[0x21] = 0x00;
	// addr: 91A	opcodes: 75 25 02
	RAM[0x25] = 0x02;
	// addr: 91D	opcodes: 22
	return; // return (opcode: 0x22)
label_91E:	// addr: 91E	opcodes: B4 01 0B
	if (accumulator != 0x01) goto label_92C;
label_921:	// addr: 921	opcodes: 78 FF
	R0 = 0xFF;
	// addr: 923	opcodes: 79 01
	R1 = 0x01;
	// addr: 925	opcodes: 75 21 00
	RAM[0x21] = 0x00;
	// addr: 928	opcodes: 75 25 04
	RAM[0x25] = 0x04;
	// addr: 92B	opcodes: 22
	return; // return (opcode: 0x22)
label_92C:	// addr: 92C	opcodes: 75 27 23
	RAM[0x27] = 0x23;
	// addr: 92F	opcodes: 80 F0
	goto label_921;
label_931:	// addr: 931	opcodes: B4 16 05
	if (accumulator != 0x16) goto label_939;
	// addr: 934	opcodes: 12 04 B4
	label_4B4(); // long call
	// addr: 937	opcodes: 80 28
	goto label_961;
label_939:	// addr: 939	opcodes: B4 10 22
	if (accumulator != 0x10) goto label_95E;
	// addr: 93C	opcodes: E5 43
	accumulator = RAM[0x43];
	// addr: 93E	opcodes: B4 04 05
	if (accumulator != 0x04) goto label_946;
	// addr: 941	opcodes: 12 0A FB
	label_AFB(); // long call
	// addr: 944	opcodes: 80 1B
	goto label_961;
label_946:	// addr: 946	opcodes: B4 07 0E
	if (accumulator != 0x07) goto label_957;
	// addr: 949	opcodes: D2 36
	bitSet(RAM[0x26], bit6);
	// addr: 94B	opcodes: E5 34
	accumulator = RAM[0x34];
	// addr: 94D	opcodes: 70 04
	if ( accumulator != 0 ) goto label_953;
	// addr: 94F	opcodes: D2 B4
	bitSet(Port3, bit4);
	// addr: 951	opcodes: 80 0E
	goto label_961;
label_953:	// addr: 953	opcodes: D2 B2
	bitSet(Port3, bit2);
	// addr: 955	opcodes: 80 0A
	goto label_961;
label_957:	// addr: 957	opcodes: B4 08 04
	if (accumulator != 0x08) goto label_95E;
	// addr: 95A	opcodes: 11 20
	label_820(); // absolute call
	// addr: 95C	opcodes: 80 03
	goto label_961;
label_95E:	// addr: 95E	opcodes: 75 27 23
	RAM[0x27] = 0x23;
label_961:	// addr: 961	opcodes: 12 0A B9
	label_AB9(); // long call
	// addr: 964	opcodes: 75 21 00
	RAM[0x21] = 0x00;
	// addr: 967	opcodes: 75 25 10
	RAM[0x25] = 0x10;
	// addr: 96A	opcodes: 75 20 00
	RAM[0x20] = 0x00;
	// addr: 96D	opcodes: 12 09 D1
	label_9D1(); // long call
	// addr: 970	opcodes: 22
	return; // return (opcode: 0x22)
label_971:	// addr: 971	opcodes: C2 AF
	bitClear(IntEnable, bit7);
label_973:	// addr: 973	opcodes: 85 90 28
	RAM[0x28] = RAM[0x90];
	// addr: 976	opcodes: 30 42 FA
	if (bitRead(RAM[0x28], bit2) == false) goto label_973;
	// addr: 979	opcodes: C2 B5
	bitClear(Port3, bit5);
	// addr: 97B	opcodes: A2 31
	if (bitRead(RAM[0x26], bit1) == true) {
	carry = true;
	} else {
		carry = false;
	};
	// addr: 97D	opcodes: 40 06
	if ( carry ) goto label_985;
	// addr: 97F	opcodes: A2 35
	if (bitRead(RAM[0x26], bit5) == true) {
	carry = true;
	} else {
		carry = false;
	};
	// addr: 981	opcodes: 50 1B
	if ( carry == false ) goto label_99E;
	// addr: 983	opcodes: 80 02
	goto label_987;
label_985:	// addr: 985	opcodes: D2 93
	bitSet(Port1, bit3);
label_987:	// addr: 987	opcodes: E5 24
	accumulator = RAM[0x24];
	// addr: 989	opcodes: 90 40 00
	DPTR = 0x4000;
	// addr: 98C	opcodes: F0
	extRAM[DPTR] = accumulator;	// external RAM
	// addr: 98D	opcodes: 12 0B 47
	label_B47(); // long call
	// addr: 990	opcodes: C2 26
	bitClear(RAM[0x24], bit6);
	// addr: 992	opcodes: D2 B5
	bitSet(Port3, bit5);
	// addr: 994	opcodes: D2 AF
	bitSet(IntEnable, bit7);
	// addr: 996	opcodes: 22
	return; // return (opcode: 0x22)
label_997:	// addr: 997	opcodes: E8
	accumulator = R0;
	// addr: 998	opcodes: C3
	carry = false; // clear carry
	// addr: 999	opcodes: 94 FF
	// Warning: SUBB a, #data, flags not fully implemented
accumulator -= carry ? 1 : 0;	// carry affected!
accumulator -= 0xFF;	// carry affected!
	// addr: 99B	opcodes: 70 01
	if ( accumulator != 0 ) goto label_99E;
	// addr: 99D	opcodes: 19
	R1--;
label_99E:	// addr: 99E	opcodes: E9
	accumulator = R1;
	// addr: 99F	opcodes: 44 10
	accumulator |= 0x10;
	// addr: 9A1	opcodes: F5 83
	RAM[0x83] = accumulator;
	// addr: 9A3	opcodes: 88 82
	RAM[0x82] = R0;
	// addr: 9A5	opcodes: E0
	accumulator = extRAM[DPTR];	// external RAM
	// addr: 9A6	opcodes: C0 83
	// Warning: PUSH 0x83 not implemented Yet!
	// addr: 9A8	opcodes: C0 82
	// Warning: PUSH 0x82 not implemented Yet!
	// addr: 9AA	opcodes: 90 40 00
	DPTR = 0x4000;
	// addr: 9AD	opcodes: F0
	extRAM[DPTR] = accumulator;	// external RAM
	// addr: 9AE	opcodes: 12 0B 47
	label_B47(); // long call
	// addr: 9B1	opcodes: D0 82
	// Warning: POP 0x82 not implemented Yet!
	// addr: 9B3	opcodes: D0 83
	// Warning: POP 0x83 not implemented Yet!
	// addr: 9B5	opcodes: D8 E0
	R0--;
if (R0 != 0) goto label_997;
	// addr: 9B7	opcodes: E9
	accumulator = R1;
	// addr: 9B8	opcodes: 70 E4
	if ( accumulator != 0 ) goto label_99E;
	// addr: 9BA	opcodes: C2 97
	bitClear(Port1, bit7);
	// addr: 9BC	opcodes: 75 83 10
	RAM[0x83] = 0x10;
	// addr: 9BF	opcodes: 75 82 00
	RAM[0x82] = 0x00;
	// addr: 9C2	opcodes: E0
	accumulator = extRAM[DPTR];	// external RAM
	// addr: 9C3	opcodes: 90 40 00
	DPTR = 0x4000;
	// addr: 9C6	opcodes: F0
	extRAM[DPTR] = accumulator;	// external RAM
	// addr: 9C7	opcodes: 12 0B 47
	label_B47(); // long call
	// addr: 9CA	opcodes: D2 97
	bitSet(Port1, bit7);
	// addr: 9CC	opcodes: D2 B5
	bitSet(Port3, bit5);
	// addr: 9CE	opcodes: D2 AF
	bitSet(IntEnable, bit7);
	// addr: 9D0	opcodes: 22
	return; // return (opcode: 0x22)
label_9D1:	// addr: 9D1	opcodes: 75 24 0F
	RAM[0x24] = 0x0F;
	// addr: 9D4	opcodes: D2 26
	bitSet(RAM[0x24], bit6);
	// addr: 9D6	opcodes: D2 0D
	bitSet(RAM[0x21], bit5);
	// addr: 9D8	opcodes: D2 31
	bitSet(RAM[0x26], bit1);
	// addr: 9DA	opcodes: 22
	return; // return (opcode: 0x22)
label_9DB:	// addr: 9DB	opcodes: 75 30 34
	RAM[0x30] = 0x34;
	// addr: 9DE	opcodes: E5 34
	accumulator = RAM[0x34];
	// addr: 9E0	opcodes: 60 05
	if ( accumulator == 0 ) goto label_9E7;
	// addr: 9E2	opcodes: 90 17 86
	DPTR = 0x1786;
	// addr: 9E5	opcodes: 80 03
	goto label_9EA;
label_9E7:	// addr: 9E7	opcodes: 90 17 50
	DPTR = 0x1750;
label_9EA:	// addr: 9EA	opcodes: E0
	accumulator = extRAM[DPTR];	// external RAM
	// addr: 9EB	opcodes: C0 83
	// Warning: PUSH 0x83 not implemented Yet!
	// addr: 9ED	opcodes: C0 82
	// Warning: PUSH 0x82 not implemented Yet!
	// addr: 9EF	opcodes: 75 83 10
	RAM[0x83] = 0x10;
	// addr: 9F2	opcodes: 15 30
	RAM[0x30]--;
	// addr: 9F4	opcodes: 85 30 82
	RAM[0x82] = RAM[0x30];
	// addr: 9F7	opcodes: 05 30
	RAM[0x30]++;
	// addr: 9F9	opcodes: F0
	extRAM[DPTR] = accumulator;	// external RAM
	// addr: 9FA	opcodes: D0 82
	// Warning: POP 0x82 not implemented Yet!
	// addr: 9FC	opcodes: D0 83
	// Warning: POP 0x83 not implemented Yet!
	// addr: 9FE	opcodes: A3
	DPTR++;
	// addr: 9FF	opcodes: D5 30 E8
	RAM[0x30]--;
if (RAM[0x30] == 0) goto label_9EA;
	// addr: A02	opcodes: 78 33
	R0 = 0x33;
	// addr: A04	opcodes: 79 00
	R1 = 0x00;
	// addr: A06	opcodes: 75 25 80
	RAM[0x25] = 0x80;
	// addr: A09	opcodes: 22
	return; // return (opcode: 0x22)
label_A0A:	// addr: A0A	opcodes: 75 30 36
	RAM[0x30] = 0x36;
	// addr: A0D	opcodes: 90 17 50
	DPTR = 0x1750;
	// addr: A10	opcodes: 74 09
	accumulator = 0x09;
	// addr: A12	opcodes: 12 0A 34
	label_A34(); // long call
	// addr: A15	opcodes: 90 17 50
	DPTR = 0x1750;
	// addr: A18	opcodes: 12 0A 29
	label_A29(); // long call
	// addr: A1B	opcodes: 75 30 36
	RAM[0x30] = 0x36;
	// addr: A1E	opcodes: 90 17 86
	DPTR = 0x1786;
	// addr: A21	opcodes: 74 09
	accumulator = 0x09;
	// addr: A23	opcodes: 12 0A 34
	label_A34(); // long call
	// addr: A26	opcodes: 90 17 86
	DPTR = 0x1786;
label_A29:	// addr: A29	opcodes: E5 82
	accumulator = RAM[0x82];
	// addr: A2B	opcodes: C3
	carry = false; // clear carry
	// addr: A2C	opcodes: 34 06
	// Warning: ADDC a, #data, flags not fully implemented
accumulator += carry ? 1 : 0;	// carry affected!
accumulator += 0x06;	// carry affected!
	// addr: A2E	opcodes: F5 82
	RAM[0x82] = accumulator;
	// addr: A30	opcodes: E5 46
	accumulator = RAM[0x46];
	// addr: A32	opcodes: F0
	extRAM[DPTR] = accumulator;	// external RAM
	// addr: A33	opcodes: 22
	return; // return (opcode: 0x22)
label_A34:	// addr: A34	opcodes: C0 E0
	// Warning: PUSH 0xE0 not implemented Yet!
	// addr: A36	opcodes: 83
	// Warning: // MOVC A, @A + PC, Not implemented because runtime stuff!
// accumulator = ROM[accumulator + PC];
	// addr: A37	opcodes: F0
	extRAM[DPTR] = accumulator;	// external RAM
	// addr: A38	opcodes: D0 E0
	// Warning: POP 0xE0 not implemented Yet!
	// addr: A3A	opcodes: 04
	accumulator++;
	// addr: A3B	opcodes: A3
	DPTR++;
	// addr: A3C	opcodes: D5 30 F5
	RAM[0x30]--;
if (RAM[0x30] == 0) goto label_A34;
	// addr: A3F	opcodes: 22
	return; // return (opcode: 0x22)
0x00, 0x02, 0xF8, 0x01, 0xD0, 0x02, 0x01,  0x01, !0x01, 0x01, 0x00, 0x00, 48 TPI DS DD FLOPPY    300237-000x00, 0x02, 0x09, 0x00, 0x02, 0x00, 0x05, 0x01, label_A76:	// addr: A76	opcodes: 75 30 FF
	RAM[0x30] = 0xFF;
	// addr: A79	opcodes: 75 31 11
	RAM[0x31] = 0x11;
	// addr: A7C	opcodes: E5 34
	accumulator = RAM[0x34];
	// addr: A7E	opcodes: 60 05
	if ( accumulator == 0 ) goto label_A85;
	// addr: A80	opcodes: 90 17 86
	DPTR = 0x1786;
	// addr: A83	opcodes: 80 03
	goto label_A88;
label_A85:	// addr: A85	opcodes: 90 17 50
	DPTR = 0x1750;
label_A88:	// addr: A88	opcodes: C0 83
	// Warning: PUSH 0x83 not implemented Yet!
	// addr: A8A	opcodes: C0 82
	// Warning: PUSH 0x82 not implemented Yet!
	// addr: A8C	opcodes: 85 31 83
	RAM[0x83] = RAM[0x31];
	// addr: A8F	opcodes: 85 30 82
	RAM[0x82] = RAM[0x30];
	// addr: A92	opcodes: 15 30
	RAM[0x30]--;
	// addr: A94	opcodes: E0
	accumulator = extRAM[DPTR];	// external RAM
	// addr: A95	opcodes: D0 82
	// Warning: POP 0x82 not implemented Yet!
	// addr: A97	opcodes: D0 83
	// Warning: POP 0x83 not implemented Yet!
	// addr: A99	opcodes: F0
	extRAM[DPTR] = accumulator;	// external RAM
	// addr: A9A	opcodes: A3
	DPTR++;
	// addr: A9B	opcodes: E5 30
	accumulator = RAM[0x30];
	// addr: A9D	opcodes: B4 C9 E8
	if (accumulator != 0xC9) goto label_A88;
	// addr: AA0	opcodes: E5 34
	accumulator = RAM[0x34];
	// addr: AA2	opcodes: 60 07
	if ( accumulator == 0 ) goto label_AAB;
	// addr: AA4	opcodes: 90 17 86
	DPTR = 0x1786;
	// addr: AA7	opcodes: 51 29
	label_A29(); // absolute call
	// addr: AA9	opcodes: 80 05
	goto label_AB0;
label_AAB:	// addr: AAB	opcodes: 90 17 50
	DPTR = 0x1750;
	// addr: AAE	opcodes: 51 29
	label_A29(); // absolute call
label_AB0:	// addr: AB0	opcodes: 75 27 00
	RAM[0x27] = 0x00;
	// addr: AB3	opcodes: 75 41 00
	RAM[0x41] = 0x00;
	// addr: AB6	opcodes: 31 61
	label_961(); // absolute call
	// addr: AB8	opcodes: 22
	return; // return (opcode: 0x22)
label_AB9:	// addr: AB9	opcodes: 75 25 10
	RAM[0x25] = 0x10;
	// addr: ABC	opcodes: 75 30 06
	RAM[0x30] = 0x06;
	// addr: ABF	opcodes: 75 83 10
	RAM[0x83] = 0x10;
	// addr: AC2	opcodes: 85 30 82
	RAM[0x82] = RAM[0x30];
	// addr: AC5	opcodes: E5 27
	accumulator = RAM[0x27];
	// addr: AC7	opcodes: F0
	extRAM[DPTR] = accumulator;	// external RAM
	// addr: AC8	opcodes: 15 30
	RAM[0x30]--;
	// addr: ACA	opcodes: 85 30 82
	RAM[0x82] = RAM[0x30];
	// addr: ACD	opcodes: E5 41
	accumulator = RAM[0x41];
	// addr: ACF	opcodes: F0
	extRAM[DPTR] = accumulator;	// external RAM
	// addr: AD0	opcodes: 15 30
	RAM[0x30]--;
	// addr: AD2	opcodes: 85 30 82
	RAM[0x82] = RAM[0x30];
	// addr: AD5	opcodes: E5 34
	accumulator = RAM[0x34];
	// addr: AD7	opcodes: F0
	extRAM[DPTR] = accumulator;	// external RAM
	// addr: AD8	opcodes: 15 30
	RAM[0x30]--;
	// addr: ADA	opcodes: 85 30 82
	RAM[0x82] = RAM[0x30];
	// addr: ADD	opcodes: E5 38
	accumulator = RAM[0x38];
	// addr: ADF	opcodes: F0
	extRAM[DPTR] = accumulator;	// external RAM
	// addr: AE0	opcodes: 15 30
	RAM[0x30]--;
	// addr: AE2	opcodes: 85 30 82
	RAM[0x82] = RAM[0x30];
	// addr: AE5	opcodes: E5 37
	accumulator = RAM[0x37];
	// addr: AE7	opcodes: F0
	extRAM[DPTR] = accumulator;	// external RAM
	// addr: AE8	opcodes: 15 30
	RAM[0x30]--;
	// addr: AEA	opcodes: 85 30 82
	RAM[0x82] = RAM[0x30];
	// addr: AED	opcodes: 74 00
	accumulator = 0x00;
	// addr: AEF	opcodes: F0
	extRAM[DPTR] = accumulator;	// external RAM
	// addr: AF0	opcodes: 15 30
	RAM[0x30]--;
	// addr: AF2	opcodes: 85 30 82
	RAM[0x82] = RAM[0x30];
	// addr: AF5	opcodes: F0
	extRAM[DPTR] = accumulator;	// external RAM
	// addr: AF6	opcodes: 78 06
	R0 = 0x06;
	// addr: AF8	opcodes: 79 00
	R1 = 0x00;
	// addr: AFA	opcodes: 22
	return; // return (opcode: 0x22)
label_AFB:	// addr: AFB	opcodes: 12 02 B3
	label_2B3(); // long call
	// addr: AFE	opcodes: E5 3C
	accumulator = RAM[0x3C];
	// addr: B00	opcodes: F5 2D
	RAM[0x2D] = accumulator;
	// addr: B02	opcodes: E5 3E
	accumulator = RAM[0x3E];
	// addr: B04	opcodes: F5 2C
	RAM[0x2C] = accumulator;
	// addr: B06	opcodes: E5 45
	accumulator = RAM[0x45];
	// addr: B08	opcodes: C3
	carry = false; // clear carry
	// addr: B09	opcodes: 35 38
	// Warning: ADDC a, data addr, flags not fully implemented
accumulator += carry ? 1 : 0;	// carry affected!
accumulator += RAM[0x38];	// carry affected!
	// addr: B0B	opcodes: F5 38
	RAM[0x38] = accumulator;
	// addr: B0D	opcodes: E5 44
	accumulator = RAM[0x44];
	// addr: B0F	opcodes: 35 37
	// Warning: ADDC a, data addr, flags not fully implemented
accumulator += carry ? 1 : 0;	// carry affected!
accumulator += RAM[0x37];	// carry affected!
	// addr: B11	opcodes: F5 37
	RAM[0x37] = accumulator;
	// addr: B13	opcodes: 12 02 B3
	label_2B3(); // long call
	// addr: B16	opcodes: E5 3C
	accumulator = RAM[0x3C];
	// addr: B18	opcodes: F5 4C
	RAM[0x4C] = accumulator;
	// addr: B1A	opcodes: E5 3E
	accumulator = RAM[0x3E];
	// addr: B1C	opcodes: F5 4E
	RAM[0x4E] = accumulator;
	// addr: B1E	opcodes: 75 27 00
	RAM[0x27] = 0x00;
	// addr: B21	opcodes: 75 41 00
	RAM[0x41] = 0x00;
	// addr: B24	opcodes: 22
	return; // return (opcode: 0x22)
label_B25:	// addr: B25	opcodes: 20 94 FD
	if (bitRead(Port1, bit4) == true) goto label_B25;
label_B28:	// addr: B28	opcodes: E5 90
	accumulator = RAM[0x90];
	// addr: B2A	opcodes: F4
	accumulator = ~accumulator;
	// addr: B2B	opcodes: F5 20
	RAM[0x20] = accumulator;
	// addr: B2D	opcodes: 90 40 00
	DPTR = 0x4000;
	// addr: B30	opcodes: E0
	accumulator = extRAM[DPTR];	// external RAM
	// addr: B31	opcodes: FA
	R2 = accumulator;
	// addr: B32	opcodes: 22
	return; // return (opcode: 0x22)
label_B33:	// addr: B33	opcodes: C2 95
	bitClear(Port1, bit5);
	// addr: B35	opcodes: D2 96
	bitSet(Port1, bit6);
label_B37:	// addr: B37	opcodes: 30 94 FD
	if (bitRead(Port1, bit4) == false) goto label_B37;
	// addr: B3A	opcodes: C2 96
	bitClear(Port1, bit6);
	// addr: B3C	opcodes: D2 95
	bitSet(Port1, bit5);
	// addr: B3E	opcodes: 22
	return; // return (opcode: 0x22)
label_B3F:	// addr: B3F	opcodes: D2 96
	bitSet(Port1, bit6);
label_B41:	// addr: B41	opcodes: 30 94 FD
	if (bitRead(Port1, bit4) == false) goto label_B41;
	// addr: B44	opcodes: D2 95
	bitSet(Port1, bit5);
	// addr: B46	opcodes: 22
	return; // return (opcode: 0x22)
label_B47:	// addr: B47	opcodes: 85 90 28
	RAM[0x28] = RAM[0x90];
	// addr: B4A	opcodes: 20 46 FA
	if (bitRead(RAM[0x28], bit6) == true) goto label_B47;
	// addr: B4D	opcodes: 30 45 F7
	if (bitRead(RAM[0x28], bit5) == false) goto label_B47;
	// addr: B50	opcodes: C2 94
	bitClear(Port1, bit4);
label_B52:	// addr: B52	opcodes: 85 90 28
	RAM[0x28] = RAM[0x90];
	// addr: B55	opcodes: 30 46 FA
	if (bitRead(RAM[0x28], bit6) == false) goto label_B52;
	// addr: B58	opcodes: D2 94
	bitSet(Port1, bit4);
	// addr: B5A	opcodes: 22
	return; // return (opcode: 0x22)
copywrite GRiD Systems 300237-01;
