from saleae.analyzers import HighLevelAnalyzer, AnalyzerFrame, StringSetting, NumberSetting, ChoicesSetting

class Hla(HighLevelAnalyzer):
    result_types = {
        'invert': {
            'format': '{{data.res}}'
        }
    }

    def __init__(self):
        pass

    def decode(self, frame: AnalyzerFrame):
        ch = frame.data['data']
        return AnalyzerFrame('invert', frame.start_time, frame.end_time, {
            'res': "0x{:02X}".format(~ch & 0xFF)
        })
