#ifndef _KEYMATRIX_H_
#define _KEYMATRIX_H_

//      key, shift, code, code+shift
uint8_t keyMatrix[] = {
        // 0 - 7; 0 - 31        // 0-7 - entry in table; 0-31 byte in table
        0x09,0xC9,0x89,0x8B, // TAB
        0xFF,0xFF,0xFF,0xFF,
        0xFF,0xFF,0xFF,0xFF,
        0xFF,0xFF,0xFF,0xFF,
        0xFF,0xFF,0xFF,0xFF,
        0xFF,0xFF,0xFF,0xFF,
        0xFF,0xFF,0xFF,0xFF,
        0x1B,0x1B,0x9B,0xFE, // ESC, 0xFE - strange result for Shift+Code+ESC (documentation say: 0x9B)
        //8 - 15; 32 - 63
        0x31,0x21,0xB1,0xA1, // 1
        0x39,0x28,0xB9,0xA8, // 9
        0x69,0x49,0xE9,0xE9, // i
        0x2D,0x5F,0xAD,0x7F, // -
        0xC6,0xD0,0xD4,0xD8, // LEFT
        0x27,0x22,0x60,0x5C, // '
        0x0D,0xCD,0x8D,0x8C, // RETURN
        0x2F,0x3F,0xBF,0xBF, // /
        // 16 - 23; 64 - 95
        0xFF,0xFF,0xFF,0xFF,
        0x38,0x2A,0xB8,0xAA, // 8
        0x75,0x55,0xF5,0xF5, // U
        0x70,0x50,0xF0,0xF0, // P
        0x3B,0x3A,0x7E,0x7C, // ;
        0x2C,0x3C,0x5B,0x7B, // ,
        0x2E,0x3E,0x5D,0x7D, // .
        0x6D,0x4D,0xED,0xED, // m
        // 24 - 31; 96 - 127
        0xFF,0xFF,0xFF,0xFF,
        0x37,0x26,0xB7,0xA6, // 7
        0x79,0x59,0xF9,0xF9, // Y
        0x6B,0x4B,0xEB,0xEB, // K
        0x6C,0x4C,0xEC,0xEC, // L
        0x62,0x42,0xE2,0xE2, // B
        0x6E,0x4E,0xEE,0xEE, // N
        0x76,0x56,0xF6,0xF6, // V
        // 32 - 39; 128 - 160
        0xFF,0xFF,0xFF,0xFF,
        0x36,0x5E,0xB6,0xDE, // 6
        0x74,0x54,0xF4,0xF4, // T
        0x68,0x48,0xE8,0xE8, // H
        0x6A,0x4A,0xEA,0xEA, // J
        0x78,0x58,0xF8,0xF8, // X
        0x63,0x43,0xE3,0xE3, // C
        0x71,0x51,0xF1,0xF1, // Q
        // 40 - 47; 161 - 191
        0xFF,0xFF,0xFF,0xFF,
        0x35,0x25,0xB5,0xA5, // 5
        0x72,0x52,0xF2,0xF2, // R
        0x66,0x46,0xE6,0xE6, // F
        0x67,0x47,0xE7,0xE7, // G
        0x73,0x53,0xF3,0xF3, // S
        0x61,0x41,0xE1,0xE1, // A
        0x7A,0x5A,0xFA,0xFA, // Z
        // 48 - 55; 192 - 223
        0xFF,0xFF,0xFF,0xFF,
        0x34,0x24,0xB4,0xA4, // 4
        0x33,0x23,0xB3,0xA3, // 3
        0x65,0x45,0xE5,0xE5, // E
        0x64,0x44,0xE4,0xE4, // D
        0x77,0x57,0xF7,0xF7, // W
        0x32,0x40,0xB2,0xC0, // 2
        0xFF,0xFF,0xFF,0xFF,
        // 56 - 63; 224 - 256
        0x20,0x20,0x20,0x20, // SPACE
        0x30,0x29,0xB0,0xA9, // 0
        0x6F,0x4F,0xEF,0xEF, // O
        0x3D,0x2B,0xBD,0xAB, // =
        0xC5,0xCF,0xD3,0xD7, // UP
        0xC7,0xD1,0xD5,0xD9, // RIGHT
        0xC4,0xCE,0xD2,0xD6, // DOWN
        0x08,0xC8,0x88,0x8A  // BACKSPACE
};
#endif


/*
void sendKey() {
    uint8_t R0b0, R1b0, R2b0, R3b0, R4b0, R5b0, R6b0, R7b0;
    uint8_t R4b1;
    uint8_t accumulator, tmp8;
    bool carry;
    uint16_t tmp16;

R0b0 = 0x2C;
R4b0 = 0x04;
label_14A:
accumulator = 0xEF;
accumulator &= RAM[R0b0];
RAM[R0b0] = accumulator;
R0b0++;
R0b0++;
R0b0++;
R4b0--;
if (R4b0 != 0) goto label_14A;
accumulator = RAM[keyCount];
if ( accumulator == 0 ) goto label_175;
R7b0 = accumulator;
R1b0 = 0x24;
label_15B:
accumulator = RAM[R1b0];
R2b0 = accumulator;
R4b0 = 0x04;
R0b0 = 0x2C;
label_161:
accumulator = RAM[R0b0];
if ( accumulator == 0 ) goto label_16D;
R0b0--;
accumulator = RAM[R0b0];
accumulator = ~accumulator;
accumulator++;
tmp16 = (uint16_t)accumulator + (uint16_t)R2b0;	// carry affected!
accumulator = (uint8_t)(tmp16 & 0xFF);
if (tmp16 > 0xFF) carry = true;
carry = !carry;
if ( accumulator == 0 ) goto label_1EF;
R0b0++;
label_16D:
R0b0++;
R0b0++;
R0b0++;
R4b0--;
if (R4b0 != 0) goto label_161;
label_172:
R1b0++;
R7b0--;
if (R7b0 != 0) goto label_15B;
label_175:
R0b0 = 0x2C;
R4b0 = 0x04;
label_179:
accumulator = RAM[R0b0];
if ( accumulator == 0 ) goto label_17F;
accumulator = ~accumulator;
if ( bitRead(accumulator, 4) ) goto label_1D3;
label_17F:
R0b0++;
label_180:
R0b0++;
R0b0++;
R4b0--;
if (R4b0 != 0) goto label_179;
accumulator = RAM[keyCount];
R1b0 = 0x24;
if ( accumulator == 0 ) goto label_193;
R7b0 = accumulator;
label_18C:
accumulator = RAM[R1b0];
accumulator++;
if ( accumulator ) goto label_194;
label_190:
R1b0++;
R7b0--;
if (R7b0 != 0) goto label_18C;
label_193:
return;	// Return from subroutine. Check for correct call label!
label_194:
accumulator = RAM[R1b0];
accumulator ^= 0x10;
if ( accumulator == 0 ) goto label_190;
R0b0 = 0x2C;
label_19B:
accumulator = RAM[R0b0];
if ( accumulator == 0 ) goto label_1A3;
R0b0++;
R0b0++;
R0b0++;
goto label_19B;
label_1A3:
R0b0--;
accumulator = RAM[R1b0];
RAM[R0b0] = accumulator;
R0b0++;
accumulator = R1b0;
R2b0 = accumulator;
R1b0 = 0x29;
accumulator = RAM[R1b0];
accumulator &= 0xE0;
accumulator |=0x08;
RAM[R0b0] = accumulator;
R0b0++;
RAM[R0b0] = 0x01;
R6b0 = 0x04;
R0b0 = 0x2C;
label_1B8:
accumulator = RAM[R0b0];
if ( accumulator == 0 ) goto label_1CA;
if ( bitRead(accumulator, 3) ) goto label_1CA;
if ( bitRead(accumulator, 0) ) goto label_1CA;
accumulator &= 0xF0;
accumulator |=0x04;
RAM[R0b0] = accumulator;
R0b0++;
R1b0 = 0x21;
accumulator = RAM[R1b0];
RAM[R0b0] = accumulator;
R0b0--;
label_1CA:
R0b0++;
R0b0++;
R0b0++;
R6b0--;
if (R6b0 != 0) goto label_1B8;
accumulator = R2b0;
R1b0 = accumulator;
goto label_190;
label_1D3:
accumulator = ~accumulator;
if ( bitRead(accumulator, 0) ) goto label_1E1;
accumulator &= 0xF0;
accumulator |=0x01;
RAM[R0b0] = accumulator;
R0b0++;
accumulator = 0x02;
RAM[R0b0] = accumulator;
goto label_180;
label_1E1:
R0b0++;
accumulator = RAM[R0b0];
accumulator--;
if ( accumulator == 0 ) goto label_1E9;
RAM[R0b0] = accumulator;
goto label_180;
label_1E9:
R0b0--;
RAM[R0b0] = accumulator;
pinSetNMI(LOW);
goto label_17F;
label_1EF:
R0b0++;
accumulator = RAM[R0b0];
R3b0 = accumulator;
R0b0++;
accumulator = RAM[R0b0];
R6b0 = accumulator;
accumulator = R0b0;
R4b1 = accumulator;
accumulator = R3b0;
if ( bitRead(accumulator, 3) ) goto label_20F;
if ( bitRead(accumulator, 2) ) goto label_22B;
if ( bitRead(accumulator, 1) ) goto label_249;
accumulator &= 0xE0;
accumulator |=0x08;
R3b0 = accumulator;
accumulator = 0x01;
goto label_279;
label_20F:
accumulator = R6b0;
accumulator--;
if ( accumulator == 0 ) goto label_215;
goto label_279;
label_215:
accumulator = R2b0;
//label_28A();	// this is call, check for correct return address
accumulator = translateScanCode(accumulator, RAM[0x29]);
R2b0 = accumulator;
accumulator = R3b0;
accumulator &= 0xE0;
R5b0 = accumulator;
accumulator = R2b0;
//label_2A7();	// this is call, check for correct return address
sendData(accumulator, R5b0);
accumulator = R5b0;
accumulator &= 0xF0;
accumulator |=0x04;
R3b0 = accumulator;
R0b0 = 0x21;
accumulator = RAM[R0b0];
goto label_279;
label_22B:
accumulator = R6b0;
accumulator--;
if ( accumulator == 0 ) goto label_231;
goto label_279;
label_231:
accumulator = globalState;
accumulator = ~accumulator;
if ( bitRead(accumulator, 3) ) goto label_239;
goto label_23E;
label_239:
R0b0 = 0x21;
accumulator = RAM[R0b0];
goto label_279;
label_23E:
accumulator = R3b0;
accumulator &= 0xF0;
accumulator |=0x02;
R3b0 = accumulator;
R0b0 = 0x22;
accumulator = RAM[R0b0];
goto label_279;
label_249:
accumulator = R6b0;
accumulator--;
if ( accumulator == 0 ) goto label_24F;
goto label_279;
label_24F:
accumulator = R3b0;
accumulator &= 0xE0;
R0b0 = 0x29;
accumulator = ~accumulator;
accumulator++;
tmp16 = (uint16_t)accumulator + (uint16_t)RAM[R0b0];	// carry affected!
accumulator = (uint8_t)(tmp16 & 0xFF);
if (tmp16 > 0xFF) carry = true;
carry = !carry;
if ( accumulator == 0 ) goto label_269;
accumulator = RAM[R0b0];
accumulator &= 0xE0;
accumulator |=0x04;
R3b0 = accumulator;
R0b0 = 0x21;
accumulator = RAM[R0b0];
goto label_279;
label_269:
accumulator = R2b0;
//label_28A();	// this is call, check for correct return address
accumulator = translateScanCode(accumulator, RAM[0x29]);
R2b0 = accumulator;
accumulator = R3b0;
accumulator &= 0xE0;
accumulator |=0x10;
R5b0 = accumulator;
accumulator = R2b0;
//label_2A7();	// this is call, check for correct return address
sendData(accumulator, R5b0);
R0b0 = 0x22;
accumulator = RAM[R0b0];
label_279:
tmp8 = R4b1;
R4b1 = accumulator;
accumulator = tmp8;
R0b0 = accumulator;
accumulator = R4b1;
RAM[R0b0] = accumulator;
R0b0--;
accumulator = R3b0;
accumulator |=0x10;
RAM[R0b0] = accumulator;
RAM[R1b0] = 0xFF;
goto label_172;
}
*/
