#ifndef _HW_INTERFACE_H_
#define _HW_INTERFACE_H_


void startTimer();
void stopTimer();
void enableTimerInterrupt();
void enableExternalInterrupt();
void disableExternalInterrupt();

#define low 0
#define high 1

bool TEST0, TEST1;  // test pins on i8741A, used for keyboard matrix
// PORT1 is used as inputs

void pinColumnSet(uint8_t num);
void pinSetIRQ4(uint8_t val);
void pinSetPAL(uint8_t val);
void pinSetNMI(uint8_t val);
void pinSetWTF(uint8_t val);

bool pinReadT0();
bool pinReadT1();

uint8_t portRead(uint8_t port);
void portWrite(uint8_t data, uint8_t port);

// busSatus register flags
#define OBF 0       // Output buffer full. CPU not read data yet
#define IBF 1       // Input buffer full. CPU send data. Need to parse.
//#define F0  2       // User settable flag (not used)
#define F1  3       // data (0)/command(1) Flag. Set when CPU send data
#define ST4 4       // User settable flag
#define ST5 5       // User settable flag - SHIFT key?
#define ST6 6       // User settable flag - CODE key?
#define ST7 7       // User settable flag - CTRL key?
uint8_t busStatus;

uint8_t busRead();
void busWrite(uint8_t data);

uint8_t timer;

#endif

