#ifndef _KEYMAP_H_
#define _KEYMAP_H_

#include <stdint.h>
#include <SDL2/SDL.h>


struct _keyTranslateMatrixEntry{
    char        name[12];
    uint32_t    sdlKeyName;
    uint8_t     unshifted;
    uint8_t     shift;
    uint8_t     code;
    uint8_t     codeShift;
    uint8_t     ctrl;
    uint8_t     shiftCtrl;
    uint8_t     codeCtrl;
    uint8_t     codeShiftCtr;
};

struct _keyTranslateMatrixEntry keyTranslateMatrix[] = {

//Name          /SDL_Key        unshi   shift   code    cdSh    ctrl    shCt    cdCt    cdShCt
{"\'",          SDLK_QUOTE,     0x27,   0x22,   0x60,   0x5c,   0x07,   0x02,   0x00,   0x1c},
{",",           SDLK_COMMA,     0x2c,   0x3c,   0x5b,   0x7b,   0x0c,   0x1c,   0x1b,   0x1b},
{"-",           SDLK_MINUS,     0x2d,   0x5f,   0xad,   0x7f,   0x0d,   0x1f,   0x8d,   0x1f},
{".",           SDLK_PERIOD,    0x2e,   0x3e,   0x5d,   0x7d,   0x0e,   0x1e,   0x1d,   0x1d},
{"/",           SDLK_SLASH,     0x2f,   0x3f,   0xbf,   0xbf,   0x0f,   0x1f,   0x9f,   0x9f},
{"0",           SDLK_0,         0x30,   0x29,   0xb0,   0xa9,   0x10,   0x09,   0x90,   0x89},
{"1",           SDLK_1,         0x31,   0x21,   0xb1,   0xa1,   0x11,   0x01,   0x91,   0x81},
{"2",           SDLK_2,         0x32,   0x40,   0xb2,   0xc0,   0x12,   0x00,   0x92,   0x80},
{"3",           SDLK_3,         0x33,   0x23,   0xb3,   0xa3,   0x13,   0x03,   0x93,   0x83},
{"4",           SDLK_4,         0x34,   0x24,   0xb4,   0xa4,   0x14,   0x04,   0x94,   0x84},
{"5",           SDLK_5,         0x35,   0x25,   0xb5,   0xa5,   0x15,   0x05,   0x95,   0x85},  // 0xb4 vs 0xb5 Error in appendix A ?
{"6",           SDLK_6,         0x36,   0x5e,   0xb6,   0xde,   0x16,   0x1e,   0x96,   0x9e},
{"7",           SDLK_7,         0x37,   0x26,   0xb7,   0xa6,   0x17,   0x06,   0x97,   0x86},
{"8",           SDLK_8,         0x38,   0x2a,   0xb8,   0xaa,   0x18,   0x0a,   0x98,   0x8a},
{"9",           SDLK_9,         0x39,   0x28,   0xb9,   0xa8,   0x19,   0x08,   0x99,   0x88},
{";",           SDLK_SEMICOLON, 0x3b,   0x3a,   0x7e,   0x7c,   0x1b,   0x1a,   0x1e,   0x1c},
{"=",           SDLK_EQUALS,    0x3d,   0x2b,   0xbd,   0xab,   0x1d,   0x0b,   0x9d,   0x8b},
{"A",           SDLK_a,         0x61,   0x41,   0xe1,   0xe1,   0x01,   0x01,   0x81,   0x81},
{"B",           SDLK_b,         0x62,   0x42,   0xe2,   0xe2,   0x02,   0x02,   0x82,   0x82},
{"C",           SDLK_c,         0x63,   0x43,   0xe3,   0xe3,   0x03,   0x03,   0x83,   0x83},
{"D",           SDLK_d,         0x64,   0x44,   0xe4,   0xe4,   0x04,   0x04,   0x84,   0x84},
{"E",           SDLK_e,         0x65,   0x45,   0xe5,   0xe5,   0x05,   0x05,   0x85,   0x85},
{"F",           SDLK_f,         0x66,   0x46,   0xe6,   0xe6,   0x06,   0x06,   0x86,   0x86},
{"G",           SDLK_g,         0x67,   0x47,   0xe7,   0xe7,   0x07,   0x07,   0x87,   0x87},
{"H",           SDLK_h,         0x68,   0x48,   0xe8,   0xe8,   0x08,   0x08,   0x88,   0x88},
{"I",           SDLK_i,         0x69,   0x49,   0xe9,   0xe9,   0x09,   0x09,   0x89,   0x89},
{"J",           SDLK_j,         0x6a,   0x4a,   0xea,   0xea,   0x0a,   0x0a,   0x8a,   0x8a},
{"K",           SDLK_k,         0x6b,   0x4b,   0xeb,   0xeb,   0x0b,   0x0b,   0x8b,   0x8b},
{"L",           SDLK_l,         0x6c,   0x4c,   0xec,   0xec,   0x0c,   0x0c,   0x8c,   0x8c},
{"M",           SDLK_m,         0x6d,   0x4d,   0xed,   0xed,   0x0d,   0x0d,   0x8d,   0x8d},
{"N",           SDLK_n,         0x6e,   0x4e,   0xee,   0xee,   0x0e,   0x0e,   0x8e,   0x8e},
{"O",           SDLK_o,         0x6f,   0x4f,   0xef,   0xef,   0x0f,   0x0f,   0x8f,   0x8f},
{"P",           SDLK_p,         0x70,   0x50,   0xf0,   0xf0,   0x10,   0x10,   0x90,   0x90},
{"Q",           SDLK_q,         0x71,   0x51,   0xf1,   0xf1,   0x11,   0x11,   0x91,   0x91},
{"R",           SDLK_r,         0x72,   0x52,   0xf2,   0xf2,   0x12,   0x12,   0x92,   0x92},
{"S",           SDLK_s,         0x73,   0x53,   0xf3,   0xf3,   0x13,   0x13,   0x93,   0x93},
{"T",           SDLK_t,         0x74,   0x54,   0xf4,   0xf4,   0x14,   0x14,   0x94,   0x94},
{"U",           SDLK_u,         0x75,   0x55,   0xf5,   0xf5,   0x15,   0x15,   0x95,   0x95},
{"V",           SDLK_v,         0x76,   0x56,   0xf6,   0xf6,   0x16,   0x16,   0x96,   0x96},
{"W",           SDLK_w,         0x77,   0x57,   0xf7,   0xf7,   0x17,   0x17,   0x97,   0x97},
{"X",           SDLK_x,         0x78,   0x58,   0xf8,   0xf8,   0x18,   0x18,   0x98,   0x98},
{"Y",           SDLK_y,         0x79,   0x59,   0xf9,   0xf9,   0x19,   0x19,   0x99,   0x99},
{"Z",           SDLK_z,         0x7a,   0x5a,   0xfa,   0xfa,   0x1a,   0x1a,   0x9a,   0x9a},
{"BACKSPACE",   SDLK_BACKSPACE, 0x08,   0xc8,   0x88,   0x8a,   0x08,   0x88,   0x88,   0x8a},
{"Return",      SDLK_RETURN,    0x0d,   0xcd,   0x8d,   0x8c,   0x0d,   0x8d,   0x8d,   0x8c},
{"DownArrow",   SDLK_DOWN,      0xc4,   0xce,   0xd2,   0xd6,   0x84,   0x8e,   0x92,   0x96},
{"ESC",         SDLK_ESCAPE,    0x1b,   0x1b,   0x9b,   0x9b,   0x1b,   0x1b,   0x9b,   0x9b},  // 0x1b, 0x1b 0x9b, 0xFE according to KBC ROM
{"LeftArrow",   SDLK_LEFT,      0xc6,   0xd0,   0xd4,   0xd8,   0x86,   0x90,   0x94,   0x98},
{"RightArrow",  SDLK_RIGHT,     0xc7,   0xd1,   0xd5,   0xd9,   0x87,   0x91,   0x95,   0x99},
{"Spacebar",    SDLK_SPACE,     0x20,   0x20,   0x20,   0x20,   0x00,   0x00,   0x00,   0x00},
{"TAB",         SDLK_TAB,       0x09,   0xc9,   0x89,   0x8b,   0x09,   0x89,   0x89,   0x8b},
{"UpArrow",     SDLK_UP,        0xc5,   0xcf,   0xd3,   0xd7,   0x85,   0x8f,   0x93,   0x97}

};

#endif

