// Hardware dependent part.
// Must be implemented on target microcontroller.
#ifndef _HW_INTERFACE_H_
#define _HW_INTERFACE_H_

void timerSet(uint8_t data);
void timerStart();
void timerStop();
void timerEnableIRQ();
void timerDisableIRQ();


void enableExternalInterrupt();
void disableExternalInterrupt();

#define LOW 0
#define HIGH 1

// PORT1 is used as inputs

void pinSetColumn(uint8_t num);
void pinSetIRQ4(uint8_t val);
void pinSetPAL(uint8_t val);
void pinSetNMI(uint8_t val);
void pinSetWTF(uint8_t val);

bool pinT0();
bool pinT1();

uint8_t portRead();

bool busReadOBF();
bool busReadF1();

uint8_t busReadStatus();
void busWriteStatus(uint8_t status);

uint8_t busReadData();
void busWriteData(uint8_t data);

#endif

