#define extIRQaddress       0x003
#define timerIRQaddress     0x007
#define extIRQindex         98
#define timerIRQindex       99

struct _opcode {
    int index;
    char pattern[20];
    char diasm[32];
};

struct _opcode opcodes[] = {
    {0, "01101rrr", "add  a,%R"},
    {1, "0110000r", "add  a,@%R"},
    {2, "00000011dddddddd", "add a,#$%X"},
    {3, "01111rrr", "addc a,%R"},
    {4, "0111000r", "addc a,@%R"},
    {5, "00010011dddddddd", "addc a,#$%X"},
    {6, "01011rrr", "anl  a,%R"},
    {7, "0101000r", "anl  a,@%R"},
    {8, "01010011dddddddd", "anl  a,#$%X"},
    {9, "10011001dddddddd", "anl  p1,#$%X"},
    {10, "10011010dddddddd", "anl  p2,#$%X"},
    {11, "100111pp", "anld %P,a"},
    {12, "0aa10100aaaaaaaa", "call %A"},
    {13, "00100111", "clr  a"},
    {14, "10010111", "clr  c"},
    {15, "10100101", "clr  f1"},
    {16, "10000101", "clr  f0"},
    {17, "00110111", "cpl  a"},
    {18, "10100111", "cpl  c"},
    {19, "10010101", "cpl  f0"},
    {20, "10110101", "cpl  f1"},
    {21, "01010111", "da   a"},
    {22, "00000111", "dec  a"},
    {23, "11001rrr", "dec  %R"},
    {24, "00010101", "dis  i"},
    {25, "00110101", "dis  tcnti"},
    {26, "11101rrraaaaaaaa", "djnz %R,%J"},
    {27, "11100101", "en   DMA"},
    {28, "11110101", "en   FLAGS"},
    {29, "00000101", "en   i"},
    {30, "00100101", "en   tcnti"},
    {31, "00100010", "in   a,DBB"},
    {32, "00001001", "in   a,p1"},
    {33, "00001010", "in   a,p2"},
    {34, "00010111", "inc  a"},
    {35, "00011rrr", "inc  %R"},
    {36, "0001000r", "inc  @%R"},
    {37, "bbb10010aaaaaaaa", "jb%B  %J"},
    {38, "11110110aaaaaaaa", "jc   %J"},
    {39, "10110110aaaaaaaa", "jf0  %J"},
    {40, "01110110aaaaaaaa", "jf1  %J"},
    {41, "aaa00100aaaaaaaa", "jmp  %A"},
    {42, "10110011", "jmpp @a"},
    {43, "11100110aaaaaaaa", "jnc  %J"},
    {44, "11010110aaaaaaaa", "jnibf  %J"},
    {45, "00100110aaaaaaaa", "jnt0 %J"},
    {46, "01000110aaaaaaaa", "jnt1 %J"},
    {47, "10010110aaaaaaaa", "jnz  %J"},
    {48, "10000110aaaaaaaa", "jobf  %J"},
    {49, "00010110aaaaaaaa", "jtf  %J"},
    {50, "00110110aaaaaaaa", "jt0  %J"},
    {51, "01010110aaaaaaaa", "jt1  %J"},
    {52, "11000110aaaaaaaa", "jz   %J"},
    {53, "00100011dddddddd", "mov  a,#$%X"},
    {54, "11000111", "mov  a,psw"},
    {55, "11111rrr", "mov  a,%R"},
    {56, "1111000r", "mov  a,@%R"},
    {57, "01000010", "mov  a,t"},
    {58, "11010111", "mov  psw,a"},
    {59, "10101rrr", "mov  %R,a"},
    {60, "10111rrrdddddddd", "mov  %R,#$%X"},
    {61, "1010000r", "mov  @%R,a"},
    {62, "1011000rdddddddd", "mov  @%R,#$%X"},
    {63, "10010000", "mov  sts,a"},
    {64, "01100010", "mov  t,a"},
    {66, "000011pp", "movd a,%P"},
    {67, "001111pp", "movd %P,a"},
    {67, "10100011", "movp a,@a"},
    {68, "11100011", "movp3 a,@a"},
    {69, "00000000", "nop"},
    {70, "01001rrr", "orl  a,%R"},
    {71, "0100000r", "orl  a,@%R"},
    {72, "01000011dddddddd", "orl  a,#$%X"},
    {73, "10001001dddddddd", "orl  p1,#$%X"},
    {74, "10001010dddddddd", "orl  p2,#$%X"},
    {75, "100011pp", "orld %P,a"},
    {76, "00000010", "outl bus,a"},
    {77, "00111001", "outl p1,a"},
    {78, "00111010", "outl p2,a"},
    {79, "10000011", "ret"},
    {80, "10010011", "retr"},
    {81, "11100111", "rl   a"},
    {82, "11110111", "rlc  a"},
    {83, "01110111", "rr   a"},
    {84, "01100111", "rrc  a"},
    {85, "11000101", "sel  rb0"},
    {86, "11010101", "sel  rb1"},
    {87, "01100101", "stop tcnt"},
    {88, "01000101", "strt cnt"},
    {89, "01010101", "strt t"},
    {90, "01000111", "swap a"},
    {91, "00101rrr", "xch  a,%R"},
    {92, "0010000r", "xch  a,@%R"},
    {93, "0011000r", "xchd a,@%R"},
    {94, "11011rrr", "xrl  a,%R"},
    {95, "1101000r", "xrl  a,@%R"},
    {96, "11010011dddddddd", "xrl  a,#$%X"},
    {97, "eof", "eof"},
    {98, "IRQ ext", "IRQ ext"},
    {99, "IRQ timer", "IRQ timer"},
};
