#ifndef _SDLCONSOLE_H_
#define _SDLCONSOLE_H_

#include <SDL2/SDL.h>
// FIXME: need more elegant way for key declaration
#define SDLCONSOLE_EVENT_NONE       0
#define SDLCONSOLE_EVENT_KEY        1
#define SDLCONSOLE_EVENT_QUIT       2
#define SDLCONSOLE_EVENT_DEBUG_1    3
#define SDLCONSOLE_EVENT_DEBUG_2    4
#define SDLCONSOLE_EVENT_UP         5
#define SDLCONSOLE_EVENT_DOWN       6
#define SDLCONSOLE_EVENT_LEFT       7
#define SDLCONSOLE_EVENT_RIGHT      8
#define SDLCONSOLE_EVENT_RETURN     9
#define SDLCONSOLE_EVENT_SPACE      10

#define GRID_SCREEN_COLOR    0xffeb00   // Amber color 0xffeb00 Sharp datasheet tells 585 nm wavelenght
//#define GRID_SCREEN_COLOR    0xffC000   // Amber color 0xffC000 By wikipedia and online color pickers

/*
 * init SDL and create terminal window
 * termW (0 - 65535)- width of terminal
 * termH (0 - 65535)- height of terminal
 * title - char array - name of window
 * fontfile - char array - path/filename where .bmp font is located
 * no error handling, don't mess with extreme values
 */
int sdlconsole_init(uint16_t termW, uint16_t termH, char *title, char *fontFile);
/*
 * Please do this when you done!
 * Frees aloocated memory!
 */
void sdlconsole_end();

/*
 * This is good old loop, call this regularly
 * Refresh happens 100 times per second
 * returns some kind (need to rewrite better) of pressed key data
 */
int sdlconsole_loop();

/*
 * draws square
 * don't mess with x,y,w,h values. Function have basic checking for boundaries
 * and return without any changes if detect boundary error
 * but better not challenge it or you can get segmentation fault
 * x, y (0-65535) - upper left corner of char region square
 * w, h (0-65535) - lower right corner of char region square
 * title - char array - write title on square
 * if title =="" (zero lenght string) - just draws horizontal top line
 * if title have some data - writes on left side of top horizontal line
 */
//void sdlconsole_drawSquare(uint16_t x, uint16_t y, uint16_t w, uint16_t h, char* title);
void sdlconsole_drawSquare(uint16_t x, uint16_t y, uint16_t w, uint16_t h, char* title, bool overlap);
/*
 * scroll caharacters in terminal buffer
 * don't mess with x,y,w,h,scrollAmount values. Function have basic checking for boundaries
 * and return without any changes if detect boundary error
 * but better not challenge it or you can get segmentation fault
 * x, y (0-65535) - upper left corner of char region square
 * w, h (0-65535) - lower right corner of char region square
 *
 * scrollAmount (w,h or less) - how many lines to scroll
 *
 * direction - where to scroll: left, right, up, down
 * use constants form scrollDirection enumerator (see below)
 *
 * newData - feed now data in empty space
 * newData size must be the same as h or w, depending on scroll direction
 * otherwise will ot clear data
 */
void sdlconsole_scroll(uint16_t x, uint16_t y, uint16_t w, uint16_t h, uint16_t scrollAmount, uint8_t direction, char* newLine);

enum scrollDirection {
    SCROLL_UP,
    SCROLL_DOWN,
    SCROLL_LEFT,
    SCROLL_RIGHT
};

/*
 * put character (0-255) in terminal buffer
 * at location x, y (0-65535)
 */
void sdlconsole_putChar(uint8_t charNum, uint16_t x, uint16_t y);
/*
 * get character from terminal buffer at location x, y (0-065535)
 */
uint8_t sdlconsole_getChar(uint16_t x, uint16_t y);

//uint32_t sdlconsole_getScanCode();
//uint8_t sdlconsole_getModKeys();
//uint8_t sdlconsole_translateScancode(SDL_Keycode keyval);
//uint8_t sdlconsole_translateScancode(SDLKey keyval);

uint64_t timing_getCur();

uint8_t sdlconsole_overlapSolver(uint8_t newChar, uint16_t x, uint16_t y, uint8_t whatLine);
#endif
