#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <stdbool.h>

// nice routines from friend
#define bitRead(value, bit) (((value) >> (bit)) & 0x01)
#define bitSet(value, bit) ((value) |= (1UL << (bit)))
#define bitClear(value, bit) ((value) &= ~(1UL << (bit)))
#define bitToggle(value, bit) ((value) ^= (1UL << (bit)))
#define bitWrite(value, bit, bitvalue) ((bitvalue) ? bitSet(value, bit) : bitClear(value, bit))

#define bit0 0
#define bit1 1
#define bit2 2
#define bit3 3
#define bit4 4
#define bit5 5
#define bit6 6
#define bit7 7

uint8_t Port1, Port2;
uint8_t TCON, SCON, IntEnable, IntPriority, PSW;

uint8_t RAM[0x100];
uint8_t accumulator, regB, tmp8;
uint8_t R0, R1, R2, R3, R4, R5, R6, R7;
uint16_t DPTR, tmp16;
bool carry, tmpCarry;

int main(int argc, char **argv) {

label_000:	// addr: 000	opcodes: 04 68
	goto label_068; // jump
label_002:	// addr: 002	opcodes: FF
	accumulator = R7;
label_003:	// addr: 003	opcodes: 04 A0
	goto label_0A0; // jump
label_005:	// addr: 005	opcodes: FF
	accumulator = R7;
label_006:	// addr: 006	opcodes: FF
	accumulator = R7;
label_007:	// addr: 007	opcodes: 65
	startTimer(false);
	// addr: 008	opcodes: D5
	// Bank1 in use
label_009:	// addr: 009	opcodes: AB
	R3 = accumulator;
	// addr: 00A	opcodes: 86 10
	if ( outputBuffer ) goto label_010;
	// addr: 00C	opcodes: 9A F7
	portWrite(portRead(PF7) & 0x02, P2;
	// addr: 00E	opcodes: 54 CA
	label_2CA(); // call
label_010:	// addr: 010	opcodes: 23 AD
	accumulator = 0xAD;
	// addr: 012	opcodes: 62
	setTimer(accumualtor);
	// addr: 013	opcodes: 16 15
	if ( timerOverflow() ) goto label_015;
label_015:	// addr: 015	opcodes: 55
	startTimer(modeTimer);
	// addr: 016	opcodes: FF
	accumulator = R7;
	// addr: 017	opcodes: 37
	accumulator = ~accumulator;
	// addr: 018	opcodes: 52 28
	if (bitRead(accumulator, 0x2) != 0) goto label_028;
	// addr: 01A	opcodes: EE 28
	R6--;
if (R6 != 0) goto label_028;
	// addr: 01C	opcodes: B8 20
	R0 = 0x20;
	// addr: 01E	opcodes: F0
	accumulator = RAM[R0];
	// addr: 01F	opcodes: AE
	R6 = accumulator;
label_020:	// addr: 020	opcodes: B8 29
	R0 = 0x29;
	// addr: 022	opcodes: F0
	accumulator = RAM[R0];
	// addr: 023	opcodes: AD
	R5 = accumulator;
label_024:	// addr: 024	opcodes: 23 FF
	accumulator = 0xFF;
	// addr: 026	opcodes: 54 A7
	label_2A7(); // call
label_028:	// addr: 028	opcodes: EA 30
	R2--;
if (R2 != 0) goto label_030;
	// addr: 02A	opcodes: BA 02
	R2 = 0x02;
	// addr: 02C	opcodes: FF
	accumulator = R7;
	// addr: 02D	opcodes: 43 80
	accumulator |= 0x80;
	// addr: 02F	opcodes: AF
	R7 = accumulator;
label_030:	// addr: 030	opcodes: FB
	accumulator = R3;
label_031:	// addr: 031	opcodes: 93
	return; // return RETR (opcode: 0x93)
label_032:	// addr: 032	opcodes: 05
	enableEXIRQ(true);
	// addr: 033	opcodes: D5
	// Bank1 in use
	// addr: 034	opcodes: 15
	enableEXIRQ(false);
label_035:	// addr: 035	opcodes: FF
	accumulator = R7;
	// addr: 036	opcodes: 37
	accumulator = ~accumulator;
	// addr: 037	opcodes: F2 32
	if (bitRead(accumulator, 0x2) != 0) goto label_032;
label_039:	// addr: 039	opcodes: 37
	accumulator = ~accumulator;
	// addr: 03A	opcodes: 53 7F
	accumulator &= 0x7F;
	// addr: 03C	opcodes: AF
	R7 = accumulator;
	// addr: 03D	opcodes: 05
	enableEXIRQ(true);
	// addr: 03E	opcodes: 37
	accumulator = ~accumulator;
	// addr: 03F	opcodes: 32 52
	if (bitRead(accumulator, 0x2) != 0) goto label_052;
label_041:	// addr: 041	opcodes: B9 39
	R1 = 0x39;
	// addr: 043	opcodes: F1
	accumulator = RAM[R1];
	// addr: 044	opcodes: 07
	accumulator--;
	// addr: 045	opcodes: A1
	RAM[R1] = accumulator;
	// addr: 046	opcodes: C6 4A
	if ( carry ) goto label_04A;
	// addr: 048	opcodes: 04 52
	goto label_052; // jump
label_04A:	// addr: 04A	opcodes: 9A EF
	portWrite(portRead(PEF) & 0x02, P2;
	// addr: 04C	opcodes: BD 00
	R5 = 0x00;
	// addr: 04E	opcodes: 23 FD
	accumulator = 0xFD;
	// addr: 050	opcodes: 54 A7
	label_2A7(); // call
label_052:	// addr: 052	opcodes: D5
	// Bank1 in use
	// addr: 053	opcodes: FF
	accumulator = R7;
	// addr: 054	opcodes: 37
	accumulator = ~accumulator;
	// addr: 055	opcodes: C5
	// Bank0 in use
	// addr: 056	opcodes: 12 32
	if (bitRead(accumulator, 0x2) != 0) goto label_032;
	// addr: 058	opcodes: 34 1A
	label_11A(); // call
	// addr: 05A	opcodes: 14 DB
	label_0DB(); // call
	// addr: 05C	opcodes: 23 03
	accumulator = 0x03;
	// addr: 05E	opcodes: 37
	accumulator = ~accumulator;
	// addr: 05F	opcodes: 17
	accumulator++;
	// addr: 060	opcodes: 6D
	// Warning: ADD a, Rn, flags not fully implemented
tmp16 = (uint16_t)accumulator + (uint16_t)R5;
accumulator = (uint8_t)(tmp16 & 0xFF);
if (tmp16 > 0xFF) carry = true;
label_061:	// addr: 061	opcodes: A7
	carry = !carry;
	// addr: 062	opcodes: E6 32
	if ( carry == false ) goto label_032;
	// addr: 064	opcodes: 34 46
	label_146(); // call
	// addr: 066	opcodes: 04 32
	goto label_032; // jump
label_068:	// addr: 068	opcodes: 9A 7F
	portWrite(portRead(P7F) & 0x02, P2;
	// addr: 06A	opcodes: 9A B7
	portWrite(portRead(PB7) & 0x02, P2;
	// addr: 06C	opcodes: D5
	// Bank1 in use
label_06D:	// addr: 06D	opcodes: BF 00
	R7 = 0x00;
	// addr: 06F	opcodes: BA 02
	R2 = 0x02;
	// addr: 071	opcodes: BE 01
	R6 = 0x01;
	// addr: 073	opcodes: C5
	// Bank0 in use
	// addr: 074	opcodes: B8 20
	R0 = 0x20;
	// addr: 076	opcodes: B0 01
	RAM[R0] = 0x01;
	// addr: 078	opcodes: 18
	R0++;
label_079:	// addr: 079	opcodes: B0 0F
	RAM[R0] = 0x0F;
	// addr: 07B	opcodes: 18
	R0++;
	// addr: 07C	opcodes: B0 02
	RAM[R0] = 0x02;
	// addr: 07E	opcodes: 18
	R0++;
label_07F:	// addr: 07F	opcodes: B0 32
	RAM[R0] = 0x32;
	// addr: 081	opcodes: B8 39
	R0 = 0x39;
	// addr: 083	opcodes: B0 32
	RAM[R0] = 0x32;
	// addr: 085	opcodes: B8 27
	R0 = 0x27;
	// addr: 087	opcodes: 23 00
	accumulator = 0x00;
	// addr: 089	opcodes: A0
	RAM[R0] = accumulator;
	// addr: 08A	opcodes: 18
	R0++;
	// addr: 08B	opcodes: A0
	RAM[R0] = accumulator;
label_08C:	// addr: 08C	opcodes: 18
	R0++;
	// addr: 08D	opcodes: A0
	RAM[R0] = accumulator;
	// addr: 08E	opcodes: BC 14
	R4 = 0x14;
label_090:	// addr: 090	opcodes: B8 2B
	R0 = 0x2B;
label_092:	// addr: 092	opcodes: B0 00
	RAM[R0] = 0x00;
label_094:	// addr: 094	opcodes: EC 92
	R4--;
if (R4 != 0) goto label_092;
	// addr: 096	opcodes: 23 AD
	accumulator = 0xAD;
	// addr: 098	opcodes: 62
	setTimer(accumualtor);
	// addr: 099	opcodes: 8A 80
	portWrite(portRead(P80) | 0x02, P2;
	// addr: 09B	opcodes: 55
	startTimer(modeTimer);
	// addr: 09C	opcodes: 05
	enableEXIRQ(true);
	// addr: 09D	opcodes: 25
	enableTimerIRQ(true);
	// addr: 09E	opcodes: 04 32
	goto label_032; // jump
label_0A0:	// addr: 0A0	opcodes: D5
	// Bank1 in use
	// addr: 0A1	opcodes: AB
	R3 = accumulator;
	// addr: 0A2	opcodes: B9 38
	R1 = 0x38;
	// addr: 0A4	opcodes: F1
	accumulator = RAM[R1];
label_0A5:	// addr: 0A5	opcodes: A9
	R1 = accumulator;
	// addr: 0A6	opcodes: 76 B2
	if ( flagF0 ) goto label_0B2;
	// addr: 0A8	opcodes: 22
	accumulator = busRead();
	// addr: 0A9	opcodes: A1
	RAM[R1] = accumulator;
label_0AA:	// addr: 0AA	opcodes: B9 23
	R1 = 0x23;
	// addr: 0AC	opcodes: F1
	accumulator = RAM[R1];
	// addr: 0AD	opcodes: B9 39
	R1 = 0x39;
label_0AF:	// addr: 0AF	opcodes: A1
	RAM[R1] = accumulator;
	// addr: 0B0	opcodes: FB
	accumulator = R3;
	// addr: 0B1	opcodes: 93
	return; // return RETR (opcode: 0x93)
label_0B2:	// addr: 0B2	opcodes: 22
	accumulator = busRead();
	// addr: 0B3	opcodes: 96 C3
	if ( accumulator ) goto label_0C3;
	// addr: 0B5	opcodes: 23 6A
	accumulator = 0x6A;
	// addr: 0B7	opcodes: B8 08
	R0 = 0x08;
	// addr: 0B9	opcodes: A0
	RAM[R0] = accumulator;
	// addr: 0BA	opcodes: 23 00
	accumulator = 0x00;
label_0BC:	// addr: 0BC	opcodes: 18
	R0++;
	// addr: 0BD	opcodes: A0
	RAM[R0] = accumulator;
	// addr: 0BE	opcodes: 23 01
	accumulator = 0x01;
	// addr: 0C0	opcodes: D7
	PSW = accumulator;
	// addr: 0C1	opcodes: 15
	enableEXIRQ(false);
	// addr: 0C2	opcodes: 93
	return; // return RETR (opcode: 0x93)
label_0C3:	// addr: 0C3	opcodes: F2 D0
	if (bitRead(accumulator, 0x2) != 0) goto label_0D0;
	// addr: 0C5	opcodes: AF
	R7 = accumulator;
	// addr: 0C6	opcodes: 53 10
	accumulator &= 0x10;
	// addr: 0C8	opcodes: A9
	R1 = accumulator;
	// addr: 0C9	opcodes: 0A
	accumulator = portRead(P2);
label_0CA:	// addr: 0CA	opcodes: 53 EF
	accumulator &= 0xEF;
	// addr: 0CC	opcodes: 49
	accumulator |= R1;
	// addr: 0CD	opcodes: 3A
	portWrite(accumulator, P2);
	// addr: 0CE	opcodes: 04 AA
	goto label_0AA; // jump
label_0D0:	// addr: 0D0	opcodes: D2 AA
	if (bitRead(accumulator, 0x2) != 0) goto label_0AA;
	// addr: 0D2	opcodes: B9 38
	R1 = 0x38;
	// addr: 0D4	opcodes: 53 03
	accumulator &= 0x03;
	// addr: 0D6	opcodes: 03 20
	// Warning: ADD a, #data, flags not fully implemented
tmp16 = (uint16_t)accumulator + 0x20;
accumulator = (uint8_t)(tmp16 & 0xFF);
if (tmp16 > 0xFF) carry = true;
	// addr: 0D8	opcodes: A1
	RAM[R1] = accumulator;
	// addr: 0D9	opcodes: 04 AA
	goto label_0AA; // jump
label_0DB:	// addr: 0DB	opcodes: B9 24
	R1 = 0x24;
	// addr: 0DD	opcodes: BD 00
	R5 = 0x00;
	// addr: 0DF	opcodes: BC 08
	R4 = 0x08;
label_0E1:	// addr: 0E1	opcodes: BB 08
	R3 = 0x08;
	// addr: 0E3	opcodes: FC
	accumulator = R4;
	// addr: 0E4	opcodes: 53 07
	accumulator &= 0x07;
	// addr: 0E6	opcodes: A8
	R0 = accumulator;
	// addr: 0E7	opcodes: 0A
	accumulator = portRead(P2);
	// addr: 0E8	opcodes: 53 F8
	accumulator &= 0xF8;
	// addr: 0EA	opcodes: 48
	accumulator |= R0;
	// addr: 0EB	opcodes: 3A
	portWrite(accumulator, P2);
	// addr: 0EC	opcodes: 09
	accumulator = portRead(P1);
	// addr: 0ED	opcodes: 97
	carry = false; // clear carry
	// addr: 0EE	opcodes: 37
	accumulator = ~accumulator;
label_0EF:	// addr: 0EF	opcodes: C6 F6
	if ( carry ) goto label_0F6;
	// addr: 0F1	opcodes: 67
	if (bitRead(accumulator, 0)) tmpCarry = true;
accumulator = accumulator >> 1;
if (tmpCarry) bitSet(accumulator, 7);
carry = tmpCarry;
	// addr: 0F2	opcodes: F6 FD
	if ( accumulator == 0 ) goto label_0FD;
label_0F4:	// addr: 0F4	opcodes: EB EF
	R3--;
if (R3 != 0) goto label_0EF;
label_0F6:	// addr: 0F6	opcodes: EC E1
	R4--;
if (R4 != 0) goto label_0E1;
	// addr: 0F8	opcodes: B8 37
	R0 = 0x37;
	// addr: 0FA	opcodes: FD
	accumulator = R5;
	// addr: 0FB	opcodes: A0
	RAM[R0] = accumulator;
	// addr: 0FC	opcodes: 83
	return; // return RET (opcode: 0x83)
label_0FD:	// addr: 0FD	opcodes: AA
	R2 = accumulator;
	// addr: 0FE	opcodes: 1D
	R5++;
	// addr: 0FF	opcodes: 23 03
	accumulator = 0x03;
	// addr: 101	opcodes: 37
	accumulator = ~accumulator;
	// addr: 102	opcodes: 17
	accumulator++;
	// addr: 103	opcodes: 6D
	// Warning: ADD a, Rn, flags not fully implemented
tmp16 = (uint16_t)accumulator + (uint16_t)R5;
accumulator = (uint8_t)(tmp16 & 0xFF);
if (tmp16 > 0xFF) carry = true;
	// addr: 104	opcodes: A7
	carry = !carry;
	// addr: 105	opcodes: F6 09
	if ( accumulator == 0 ) goto label_009;
	// addr: 107	opcodes: 04 F4
	goto label_0F4; // jump
	// addr: 109	opcodes: FC
	accumulator = R4;
	// addr: 10A	opcodes: E7
	accumulator = accumulator << 1;

	// addr: 10B	opcodes: E7
	accumulator = accumulator << 1;

	// addr: 10C	opcodes: E7
	accumulator = accumulator << 1;

	// addr: 10D	opcodes: 53 38
	accumulator &= 0x38;
	// addr: 10F	opcodes: A8
	R0 = accumulator;
	// addr: 110	opcodes: FB
	accumulator = R3;
	// addr: 111	opcodes: 53 07
	accumulator &= 0x07;
	// addr: 113	opcodes: 48
	accumulator |= R0;
	// addr: 114	opcodes: A1
	RAM[R1] = accumulator;
	// addr: 115	opcodes: 19
	R1++;
	// addr: 116	opcodes: FA
	accumulator = R2;
	// addr: 117	opcodes: 97
	carry = false; // clear carry
	// addr: 118	opcodes: 04 F4
	goto label_0F4; // jump
label_11A:	// addr: 11A	opcodes: 23 00
	accumulator = 0x00;
	// addr: 11C	opcodes: 56 20
	if ( pinT1() ) goto label_020;
	// addr: 11E	opcodes: 43 40
	accumulator |= 0x40;
	// addr: 120	opcodes: 36 24
	if ( pinT0() ) goto label_024;
	// addr: 122	opcodes: 43 20
	accumulator |= 0x20;
	// addr: 124	opcodes: A8
	R0 = accumulator;
	// addr: 125	opcodes: 0A
	accumulator = portRead(P2);
	// addr: 126	opcodes: 53 F8
	accumulator &= 0xF8;
	// addr: 128	opcodes: 43 02
	accumulator |= 0x02;
	// addr: 12A	opcodes: 3A
	portWrite(accumulator, P2);
	// addr: 12B	opcodes: 09
	accumulator = portRead(P1);
	// addr: 12C	opcodes: 37
	accumulator = ~accumulator;
	// addr: 12D	opcodes: 53 01
	accumulator &= 0x01;
	// addr: 12F	opcodes: C6 35
	if ( carry ) goto label_035;
	// addr: 131	opcodes: F8
	accumulator = R0;
	// addr: 132	opcodes: 43 80
	accumulator |= 0x80;
	// addr: 134	opcodes: A8
	R0 = accumulator;
	// addr: 135	opcodes: B9 2A
	R1 = 0x2A;
	// addr: 137	opcodes: F1
	accumulator = RAM[R1];
	// addr: 138	opcodes: 37
	accumulator = ~accumulator;
	// addr: 139	opcodes: 17
	accumulator++;
	// addr: 13A	opcodes: 68
	// Warning: ADD a, Rn, flags not fully implemented
tmp16 = (uint16_t)accumulator + (uint16_t)R0;
accumulator = (uint8_t)(tmp16 & 0xFF);
if (tmp16 > 0xFF) carry = true;
	// addr: 13B	opcodes: A7
	carry = !carry;
	// addr: 13C	opcodes: C6 41
	if ( carry ) goto label_041;
	// addr: 13E	opcodes: F8
	accumulator = R0;
	// addr: 13F	opcodes: A1
	RAM[R1] = accumulator;
	// addr: 140	opcodes: 83
	return; // return RET (opcode: 0x83)
	// addr: 141	opcodes: F8
	accumulator = R0;
	// addr: 142	opcodes: B9 29
	R1 = 0x29;
	// addr: 144	opcodes: A1
	RAM[R1] = accumulator;
	// addr: 145	opcodes: 83
	return; // return RET (opcode: 0x83)
label_146:	// addr: 146	opcodes: B8 2C
	R0 = 0x2C;
	// addr: 148	opcodes: BC 04
	R4 = 0x04;
	// addr: 14A	opcodes: 23 EF
	accumulator = 0xEF;
	// addr: 14C	opcodes: 50
	accumulator &= RAM[R0];
	// addr: 14D	opcodes: A0
	RAM[R0] = accumulator;
	// addr: 14E	opcodes: 18
	R0++;
	// addr: 14F	opcodes: 18
	R0++;
	// addr: 150	opcodes: 18
	R0++;
	// addr: 151	opcodes: EC 4A
	R4--;
if (R4 != 0) goto label_04A;
	// addr: 153	opcodes: B9 37
	R1 = 0x37;
	// addr: 155	opcodes: F1
	accumulator = RAM[R1];
	// addr: 156	opcodes: C6 75
	if ( carry ) goto label_075;
	// addr: 158	opcodes: AF
	R7 = accumulator;
	// addr: 159	opcodes: B9 24
	R1 = 0x24;
	// addr: 15B	opcodes: F1
	accumulator = RAM[R1];
	// addr: 15C	opcodes: AA
	R2 = accumulator;
	// addr: 15D	opcodes: BC 04
	R4 = 0x04;
	// addr: 15F	opcodes: B8 2C
	R0 = 0x2C;
	// addr: 161	opcodes: F0
	accumulator = RAM[R0];
	// addr: 162	opcodes: C6 6D
	if ( carry ) goto label_06D;
	// addr: 164	opcodes: C8
	R0--;
	// addr: 165	opcodes: F0
	accumulator = RAM[R0];
	// addr: 166	opcodes: 37
	accumulator = ~accumulator;
	// addr: 167	opcodes: 17
	accumulator++;
	// addr: 168	opcodes: 6A
	// Warning: ADD a, Rn, flags not fully implemented
tmp16 = (uint16_t)accumulator + (uint16_t)R2;
accumulator = (uint8_t)(tmp16 & 0xFF);
if (tmp16 > 0xFF) carry = true;
	// addr: 169	opcodes: A7
	carry = !carry;
	// addr: 16A	opcodes: C6 EF
	if ( carry ) goto label_0EF;
	// addr: 16C	opcodes: 18
	R0++;
	// addr: 16D	opcodes: 18
	R0++;
	// addr: 16E	opcodes: 18
	R0++;
	// addr: 16F	opcodes: 18
	R0++;
	// addr: 170	opcodes: EC 61
	R4--;
if (R4 != 0) goto label_061;
label_172:	// addr: 172	opcodes: 19
	R1++;
	// addr: 173	opcodes: EF 5B
	R7--;
if (R7 != 0) goto label_05B;
	// addr: 175	opcodes: B8 2C
	R0 = 0x2C;
	// addr: 177	opcodes: BC 04
	R4 = 0x04;
	// addr: 179	opcodes: F0
	accumulator = RAM[R0];
	// addr: 17A	opcodes: C6 7F
	if ( carry ) goto label_07F;
	// addr: 17C	opcodes: 37
	accumulator = ~accumulator;
	// addr: 17D	opcodes: 92 D3
	if (bitRead(accumulator, 0x2) != 0) goto label_0D3;
label_17F:	// addr: 17F	opcodes: 18
	R0++;
label_180:	// addr: 180	opcodes: 18
	R0++;
	// addr: 181	opcodes: 18
	R0++;
	// addr: 182	opcodes: EC 79
	R4--;
if (R4 != 0) goto label_079;
	// addr: 184	opcodes: B9 37
	R1 = 0x37;
	// addr: 186	opcodes: F1
	accumulator = RAM[R1];
	// addr: 187	opcodes: B9 24
	R1 = 0x24;
	// addr: 189	opcodes: C6 93
	if ( carry ) goto label_093;
	// addr: 18B	opcodes: AF
	R7 = accumulator;
	// addr: 18C	opcodes: F1
	accumulator = RAM[R1];
	// addr: 18D	opcodes: 17
	accumulator++;
	// addr: 18E	opcodes: 96 94
	if ( accumulator ) goto label_094;
label_190:	// addr: 190	opcodes: 19
	R1++;
	// addr: 191	opcodes: EF 8C
	R7--;
if (R7 != 0) goto label_08C;
	// addr: 193	opcodes: 83
	return; // return RET (opcode: 0x83)
	// addr: 194	opcodes: F1
	accumulator = RAM[R1];
	// addr: 195	opcodes: D3 10
	accumulator ^= 0x10;
	// addr: 197	opcodes: C6 90
	if ( carry ) goto label_090;
	// addr: 199	opcodes: B8 2C
	R0 = 0x2C;
label_19B:	// addr: 19B	opcodes: F0
	accumulator = RAM[R0];
	// addr: 19C	opcodes: C6 A3
	if ( carry ) goto label_0A3;
	// addr: 19E	opcodes: 18
	R0++;
	// addr: 19F	opcodes: 18
	R0++;
	// addr: 1A0	opcodes: 18
	R0++;
	// addr: 1A1	opcodes: 24 9B
	goto label_19B; // jump
	// addr: 1A3	opcodes: C8
	R0--;
	// addr: 1A4	opcodes: F1
	accumulator = RAM[R1];
	// addr: 1A5	opcodes: A0
	RAM[R0] = accumulator;
	// addr: 1A6	opcodes: 18
	R0++;
	// addr: 1A7	opcodes: F9
	accumulator = R1;
	// addr: 1A8	opcodes: AA
	R2 = accumulator;
	// addr: 1A9	opcodes: B9 29
	R1 = 0x29;
	// addr: 1AB	opcodes: F1
	accumulator = RAM[R1];
	// addr: 1AC	opcodes: 53 E0
	accumulator &= 0xE0;
	// addr: 1AE	opcodes: 43 08
	accumulator |= 0x08;
	// addr: 1B0	opcodes: A0
	RAM[R0] = accumulator;
	// addr: 1B1	opcodes: 18
	R0++;
	// addr: 1B2	opcodes: B0 01
	RAM[R0] = 0x01;
	// addr: 1B4	opcodes: BE 04
	R6 = 0x04;
	// addr: 1B6	opcodes: B8 2C
	R0 = 0x2C;
	// addr: 1B8	opcodes: F0
	accumulator = RAM[R0];
	// addr: 1B9	opcodes: C6 CA
	if ( carry ) goto label_0CA;
	// addr: 1BB	opcodes: 72 CA
	if (bitRead(accumulator, 0x2) != 0) goto label_0CA;
	// addr: 1BD	opcodes: 12 CA
	if (bitRead(accumulator, 0x2) != 0) goto label_0CA;
	// addr: 1BF	opcodes: 53 F0
	accumulator &= 0xF0;
	// addr: 1C1	opcodes: 43 04
	accumulator |= 0x04;
	// addr: 1C3	opcodes: A0
	RAM[R0] = accumulator;
	// addr: 1C4	opcodes: 18
	R0++;
	// addr: 1C5	opcodes: B9 21
	R1 = 0x21;
	// addr: 1C7	opcodes: F1
	accumulator = RAM[R1];
	// addr: 1C8	opcodes: A0
	RAM[R0] = accumulator;
	// addr: 1C9	opcodes: C8
	R0--;
	// addr: 1CA	opcodes: 18
	R0++;
	// addr: 1CB	opcodes: 18
	R0++;
	// addr: 1CC	opcodes: 18
	R0++;
	// addr: 1CD	opcodes: EE B8
	R6--;
if (R6 != 0) goto label_0B8;
	// addr: 1CF	opcodes: FA
	accumulator = R2;
	// addr: 1D0	opcodes: A9
	R1 = accumulator;
	// addr: 1D1	opcodes: 24 90
	goto label_190; // jump
	// addr: 1D3	opcodes: 37
	accumulator = ~accumulator;
	// addr: 1D4	opcodes: 12 E1
	if (bitRead(accumulator, 0x2) != 0) goto label_0E1;
	// addr: 1D6	opcodes: 53 F0
	accumulator &= 0xF0;
	// addr: 1D8	opcodes: 43 01
	accumulator |= 0x01;
	// addr: 1DA	opcodes: A0
	RAM[R0] = accumulator;
	// addr: 1DB	opcodes: 18
	R0++;
	// addr: 1DC	opcodes: 23 02
	accumulator = 0x02;
	// addr: 1DE	opcodes: A0
	RAM[R0] = accumulator;
	// addr: 1DF	opcodes: 24 80
	goto label_180; // jump
	// addr: 1E1	opcodes: 18
	R0++;
	// addr: 1E2	opcodes: F0
	accumulator = RAM[R0];
	// addr: 1E3	opcodes: 07
	accumulator--;
	// addr: 1E4	opcodes: C6 E9
	if ( carry ) goto label_0E9;
	// addr: 1E6	opcodes: A0
	RAM[R0] = accumulator;
	// addr: 1E7	opcodes: 24 80
	goto label_180; // jump
	// addr: 1E9	opcodes: C8
	R0--;
	// addr: 1EA	opcodes: A0
	RAM[R0] = accumulator;
	// addr: 1EB	opcodes: 9A BF
	portWrite(portRead(PBF) & 0x02, P2;
	// addr: 1ED	opcodes: 24 7F
	goto label_17F; // jump
	// addr: 1EF	opcodes: 18
	R0++;
	// addr: 1F0	opcodes: F0
	accumulator = RAM[R0];
	// addr: 1F1	opcodes: AB
	R3 = accumulator;
	// addr: 1F2	opcodes: 18
	R0++;
	// addr: 1F3	opcodes: F0
	accumulator = RAM[R0];
	// addr: 1F4	opcodes: AE
	R6 = accumulator;
	// addr: 1F5	opcodes: F8
	accumulator = R0;
	// addr: 1F6	opcodes: D5
	// Bank1 in use
	// addr: 1F7	opcodes: AC
	R4 = accumulator;
	// addr: 1F8	opcodes: C5
	// Bank0 in use
	// addr: 1F9	opcodes: FB
	accumulator = R3;
	// addr: 1FA	opcodes: 44 00
	goto label_200; // jump
	// addr: 1FC	opcodes: FF
	accumulator = R7;
	// addr: 1FD	opcodes: FF
	accumulator = R7;
	// addr: 1FE	opcodes: FF
	accumulator = R7;
	// addr: 1FF	opcodes: FF
	accumulator = R7;
label_200:	// addr: 200	opcodes: 72 0F
	if (bitRead(accumulator, 0x2) != 0) goto label_00F;
	// addr: 202	opcodes: 52 2B
	if (bitRead(accumulator, 0x2) != 0) goto label_02B;
	// addr: 204	opcodes: 32 49
	if (bitRead(accumulator, 0x2) != 0) goto label_049;
	// addr: 206	opcodes: 53 E0
	accumulator &= 0xE0;
	// addr: 208	opcodes: 43 08
	accumulator |= 0x08;
	// addr: 20A	opcodes: AB
	R3 = accumulator;
	// addr: 20B	opcodes: 23 01
	accumulator = 0x01;
	// addr: 20D	opcodes: 44 79
	goto label_279; // jump
	// addr: 20F	opcodes: FE
	accumulator = R6;
	// addr: 210	opcodes: 07
	accumulator--;
	// addr: 211	opcodes: C6 15
	if ( carry ) goto label_015;
	// addr: 213	opcodes: 44 79
	goto label_279; // jump
	// addr: 215	opcodes: FA
	accumulator = R2;
	// addr: 216	opcodes: 54 8A
	label_28A(); // call
	// addr: 218	opcodes: AA
	R2 = accumulator;
	// addr: 219	opcodes: FB
	accumulator = R3;
	// addr: 21A	opcodes: 53 E0
	accumulator &= 0xE0;
	// addr: 21C	opcodes: AD
	R5 = accumulator;
	// addr: 21D	opcodes: FA
	accumulator = R2;
	// addr: 21E	opcodes: 54 A7
	label_2A7(); // call
	// addr: 220	opcodes: FD
	accumulator = R5;
	// addr: 221	opcodes: 53 F0
	accumulator &= 0xF0;
	// addr: 223	opcodes: 43 04
	accumulator |= 0x04;
	// addr: 225	opcodes: AB
	R3 = accumulator;
	// addr: 226	opcodes: B8 21
	R0 = 0x21;
	// addr: 228	opcodes: F0
	accumulator = RAM[R0];
	// addr: 229	opcodes: 44 79
	goto label_279; // jump
	// addr: 22B	opcodes: FE
	accumulator = R6;
	// addr: 22C	opcodes: 07
	accumulator--;
	// addr: 22D	opcodes: C6 31
	if ( carry ) goto label_031;
	// addr: 22F	opcodes: 44 79
	goto label_279; // jump
	// addr: 231	opcodes: D5
	// Bank1 in use
	// addr: 232	opcodes: FF
	accumulator = R7;
	// addr: 233	opcodes: C5
	// Bank0 in use
	// addr: 234	opcodes: 37
	accumulator = ~accumulator;
	// addr: 235	opcodes: 72 39
	if (bitRead(accumulator, 0x2) != 0) goto label_039;
	// addr: 237	opcodes: 44 3E
	goto label_23E; // jump
	// addr: 239	opcodes: B8 21
	R0 = 0x21;
	// addr: 23B	opcodes: F0
	accumulator = RAM[R0];
	// addr: 23C	opcodes: 44 79
	goto label_279; // jump
label_23E:	// addr: 23E	opcodes: FB
	accumulator = R3;
	// addr: 23F	opcodes: 53 F0
	accumulator &= 0xF0;
	// addr: 241	opcodes: 43 02
	accumulator |= 0x02;
	// addr: 243	opcodes: AB
	R3 = accumulator;
	// addr: 244	opcodes: B8 22
	R0 = 0x22;
	// addr: 246	opcodes: F0
	accumulator = RAM[R0];
	// addr: 247	opcodes: 44 79
	goto label_279; // jump
	// addr: 249	opcodes: FE
	accumulator = R6;
	// addr: 24A	opcodes: 07
	accumulator--;
	// addr: 24B	opcodes: C6 4F
	if ( carry ) goto label_04F;
	// addr: 24D	opcodes: 44 79
	goto label_279; // jump
	// addr: 24F	opcodes: FB
	accumulator = R3;
	// addr: 250	opcodes: 53 E0
	accumulator &= 0xE0;
	// addr: 252	opcodes: B8 29
	R0 = 0x29;
	// addr: 254	opcodes: 37
	accumulator = ~accumulator;
	// addr: 255	opcodes: 17
	accumulator++;
	// addr: 256	opcodes: 60
	// Warning: ADD a, @R0, flags not fully implemented
tmp16 = (uint16_t)accumulator + (uint16_t)RAM[R0];
accumulator = (uint8_t)(tmp16 & 0xFF);
if (tmp16 > 0xFF) carry = true;
	// addr: 257	opcodes: A7
	carry = !carry;
	// addr: 258	opcodes: 00
	// NOP
	// addr: 259	opcodes: 00
	// NOP
	// addr: 25A	opcodes: 00
	// NOP
	// addr: 25B	opcodes: 00
	// NOP
	// addr: 25C	opcodes: C6 69
	if ( carry ) goto label_069;
	// addr: 25E	opcodes: F0
	accumulator = RAM[R0];
	// addr: 25F	opcodes: 53 E0
	accumulator &= 0xE0;
	// addr: 261	opcodes: 43 04
	accumulator |= 0x04;
	// addr: 263	opcodes: AB
	R3 = accumulator;
	// addr: 264	opcodes: B8 21
	R0 = 0x21;
	// addr: 266	opcodes: F0
	accumulator = RAM[R0];
	// addr: 267	opcodes: 44 79
	goto label_279; // jump
	// addr: 269	opcodes: FA
	accumulator = R2;
	// addr: 26A	opcodes: 54 8A
	label_28A(); // call
	// addr: 26C	opcodes: AA
	R2 = accumulator;
	// addr: 26D	opcodes: FB
	accumulator = R3;
	// addr: 26E	opcodes: 53 E0
	accumulator &= 0xE0;
	// addr: 270	opcodes: 43 10
	accumulator |= 0x10;
	// addr: 272	opcodes: AD
	R5 = accumulator;
	// addr: 273	opcodes: FA
	accumulator = R2;
	// addr: 274	opcodes: 54 A7
	label_2A7(); // call
	// addr: 276	opcodes: B8 22
	R0 = 0x22;
	// addr: 278	opcodes: F0
	accumulator = RAM[R0];
label_279:	// addr: 279	opcodes: D5
	// Bank1 in use
	// addr: 27A	opcodes: 2C
	tmp8 = R4;
R4 = accumulator;
accumulator = tmp8;
	// addr: 27B	opcodes: C5
	// Bank0 in use
	// addr: 27C	opcodes: A8
	R0 = accumulator;
	// addr: 27D	opcodes: D5
	// Bank1 in use
	// addr: 27E	opcodes: FC
	accumulator = R4;
	// addr: 27F	opcodes: C5
	// Bank0 in use
	// addr: 280	opcodes: A0
	RAM[R0] = accumulator;
	// addr: 281	opcodes: C8
	R0--;
	// addr: 282	opcodes: FB
	accumulator = R3;
	// addr: 283	opcodes: 43 10
	accumulator |= 0x10;
	// addr: 285	opcodes: A0
	RAM[R0] = accumulator;
	// addr: 286	opcodes: B1 FF
	RAM[R1] = 0xFF;
	// addr: 288	opcodes: 24 72
	goto label_172; // jump
label_28A:	// addr: 28A	opcodes: E7
	accumulator = accumulator << 1;

	// addr: 28B	opcodes: E7
	accumulator = accumulator << 1;

	// addr: 28C	opcodes: 53 FC
	accumulator &= 0xFC;
	// addr: 28E	opcodes: AD
	R5 = accumulator;
	// addr: 28F	opcodes: B8 29
	R0 = 0x29;
	// addr: 291	opcodes: F0
	accumulator = RAM[R0];
	// addr: 292	opcodes: 77
	accumulator = accumulator >> 1;
	// addr: 293	opcodes: 77
	accumulator = accumulator >> 1;
	// addr: 294	opcodes: 77
	accumulator = accumulator >> 1;
	// addr: 295	opcodes: 77
	accumulator = accumulator >> 1;
	// addr: 296	opcodes: 77
	accumulator = accumulator >> 1;
	// addr: 297	opcodes: 53 03
	accumulator &= 0x03;
	// addr: 299	opcodes: 4D
	accumulator |= R5;
	// addr: 29A	opcodes: E3
	accumulator = page3Array[accumulator];	// Double check for correct array name!
	// addr: 29B	opcodes: AD
	R5 = accumulator;
	// addr: 29C	opcodes: F0
	accumulator = RAM[R0];
	// addr: 29D	opcodes: 53 80
	accumulator &= 0x80;
	// addr: 29F	opcodes: C6 A5
	if ( carry ) goto label_0A5;
	// addr: 2A1	opcodes: 23 9F
	accumulator = 0x9F;
	// addr: 2A3	opcodes: 5D
	accumulator &= R5;
	// addr: 2A4	opcodes: AD
	R5 = accumulator;
	// addr: 2A5	opcodes: FD
	accumulator = R5;
	// addr: 2A6	opcodes: 83
	return; // return RET (opcode: 0x83)
label_2A7:	// addr: 2A7	opcodes: A8
	R0 = accumulator;
	// addr: 2A8	opcodes: D3 FE
	accumulator ^= 0xFE;
	// addr: 2AA	opcodes: 96 AF
	if ( accumulator ) goto label_0AF;
	// addr: 2AC	opcodes: 8A 40
	portWrite(portRead(P40) | 0x02, P2;
	// addr: 2AE	opcodes: 83
	return; // return RET (opcode: 0x83)
	// addr: 2AF	opcodes: F8
	accumulator = R0;
	// addr: 2B0	opcodes: B8 28
	R0 = 0x28;
	// addr: 2B2	opcodes: 86 BC
	if ( outputBuffer ) goto label_0BC;
	// addr: 2B4	opcodes: 9A F7
	portWrite(portRead(PF7) & 0x02, P2;
	// addr: 2B6	opcodes: 02
	busWrite(accumulator);
	// addr: 2B7	opcodes: FD
	accumulator = R5;
	// addr: 2B8	opcodes: 90
	statusWrite(accumulator);
	// addr: 2B9	opcodes: 8A 08
	portWrite(portRead(P8) | 0x02, P2;
	// addr: 2BB	opcodes: 83
	return; // return RET (opcode: 0x83)
	// addr: 2BC	opcodes: 20
	tmp8 = RAM[R0];
RAM[R0] = accumulator;
accumulator = tmp8;
	// addr: 2BD	opcodes: C6 C3
	if ( carry ) goto label_0C3;
	// addr: 2BF	opcodes: C8
	R0--;
	// addr: 2C0	opcodes: B0 FE
	RAM[R0] = 0xFE;
	// addr: 2C2	opcodes: 83
	return; // return RET (opcode: 0x83)
	// addr: 2C3	opcodes: 20
	tmp8 = RAM[R0];
RAM[R0] = accumulator;
accumulator = tmp8;
	// addr: 2C4	opcodes: C8
	R0--;
	// addr: 2C5	opcodes: A0
	RAM[R0] = accumulator;
	// addr: 2C6	opcodes: 18
	R0++;
	// addr: 2C7	opcodes: FD
	accumulator = R5;
	// addr: 2C8	opcodes: A0
	RAM[R0] = accumulator;
	// addr: 2C9	opcodes: 83
	return; // return RET (opcode: 0x83)
label_2CA:	// addr: 2CA	opcodes: B8 28
	R0 = 0x28;
	// addr: 2CC	opcodes: F0
	accumulator = RAM[R0];
	// addr: 2CD	opcodes: C6 DA
	if ( carry ) goto label_0DA;
	// addr: 2CF	opcodes: C8
	R0--;
	// addr: 2D0	opcodes: F0
	accumulator = RAM[R0];
	// addr: 2D1	opcodes: 02
	busWrite(accumulator);
	// addr: 2D2	opcodes: 18
	R0++;
	// addr: 2D3	opcodes: F0
	accumulator = RAM[R0];
	// addr: 2D4	opcodes: B0 00
	RAM[R0] = 0x00;
	// addr: 2D6	opcodes: 90
	statusWrite(accumulator);
	// addr: 2D7	opcodes: 8A 08
	portWrite(portRead(P8) | 0x02, P2;
	// addr: 2D9	opcodes: 83
	return; // return RET (opcode: 0x83)
	// addr: 2DA	opcodes: B8 29
	R0 = 0x29;
	// addr: 2DC	opcodes: F0
	accumulator = RAM[R0];
	// addr: 2DD	opcodes: 90
	statusWrite(accumulator);
	// addr: 2DE	opcodes: 83
	return; // return RET (opcode: 0x83)
	// addr: 2DF	opcodes: FF
	accumulator = R7;
	// addr: 2E0	opcodes: FF
	accumulator = R7;
}
page3Array [] = {
0x09, 0xC9, 0x89, 0x8B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x1B, 0x1B, 0x9B, 0xFE, 0x31, 0x21, 0xB1, 0xA1, 0x39, 0x28, 0xB9, 0xA8, 0x69, 0x49, 0xE9, 0xE9, 0x2D, 0x5F, 0xAD, 0x7F, 0xC6, 0xD0, 0xD4, 0xD8, 0x27, 0x22, 0x60, 0x5C, 0x0D, 0xCD, 0x8D, 0x8C, 0x2F, 0x3F, 0xBF, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0x38, 0x2A, 0xB8, 0xAA, 0x75, 0x55, 0xF5, 0xF5, 0x70, 0x50, 0xF0, 0xF0, 0x3B, 0x3A, 0x7E, 0x7C, 0x2C, 0x3C, 0x5B, 0x7B, 0x2E, 0x3E, 0x5D, 0x7D, 0x6D, 0x4D, 0xED, 0xED, 0xFF, 0xFF, 0xFF, 0xFF, 0x37, 0x26, 0xB7, 0xA6, 0x79, 0x59, 0xF9, 0xF9, 0x6B, 0x4B, 0xEB, 0xEB, 0x6C, 0x4C, 0xEC, 0xEC, 0x62, 0x42, 0xE2, 0xE2, 0x6E, 0x4E, 0xEE, 0xEE, 0x76, 0x56, 0xF6, 0xF6, 0xFF, 0xFF, 0xFF, 0xFF, 0x36, 0x5E, 0xB6, 0xDE, 0x74, 0x54, 0xF4, 0xF4, 0x68, 0x48, 0xE8, 0xE8, 0x6A, 0x4A, 0xEA, 0xEA, 0x78, 0x58, 0xF8, 0xF8, 0x63, 0x43, 0xE3, 0xE3, 0x71, 0x51, 0xF1, 0xF1, 0xFF, 0xFF, 0xFF, 0xFF, 0x35, 0x25, 0xB5, 0xA5, 0x72, 0x52, 0xF2, 0xF2, 0x66, 0x46, 0xE6, 0xE6, 0x67, 0x47, 0xE7, 0xE7, 0x73, 0x53, 0xF3, 0xF3, 0x61, 0x41, 0xE1, 0xE1, 0x7A, 0x5A, 0xFA, 0xFA, 0xFF, 0xFF, 0xFF, 0xFF, 0x34, 0x24, 0xB4, 0xA4, 0x33, 0x23, 0xB3, 0xA3, 0x65, 0x45, 0xE5, 0xE5, 0x64, 0x44, 0xE4, 0xE4, 0x77, 0x57, 0xF7, 0xF7, 0x32, 0x40, 0xB2, 0xC0, 0xFF, 0xFF, 0xFF, 0xFF, 0x20, 0x20, 0x20, 0x20, 0x30, 0x29, 0xB0, 0xA9, 0x6F, 0x4F, 0xEF, 0xEF, 0x3D, 0x2B, 0xBD, 0xAB, 0xC5, 0xCF, 0xD3, 0xD7, 0xC7, 0xD1, 0xD5, 0xD9, 0xC4, 0xCE, 0xD2, 0xD6, 0x08, 0xC8, 0x88, 0x8A} ;
