#include "gpiointerface.h"

FILE *G210x_image_file = NULL;

int main(int argc, char const *argv[])
{
    if (argc != 2)
    {
        fprintf(stderr, "usage: g210x <filename.img>\n");
        return 2;
    }

    if (!GPIO_IF_Init())
    {
        fprintf(stderr, "Failed to initialize GPIO\n");
        return 1;
    }

    G210x_image_file = fopen(argv[1], "r+b");
    if (!G210x_image_file)
    {
        fprintf(stderr, "Failed to open image file.\n");
        return 3;
    }

    return 0;
}
