#include "gpibinterface.h"
#include "gpiointerface.h"

// receive byte timeout in microseconds
#define GPIB_RECEIVE_TIMEOUT    300 * 1000      // 0.3 seconds


#define GPIB_MACHINE_STATE_RELEASED                 0
#define GPIB_MACHINE_STATE_ATN_ACTIVE               1
#define GPIB_MACHINE_STATE_RECEIVING_BYTE           2
#define GPIB_MACHINE_STATE_RECEIVING_BYTE_COMPLETE  3
#define GPIB_MACHINE_STATE_SENDING_BYTE             4
#define GPIB_MACHINE_STATE_SENDING_BYTE_COMPLETE    5

// GPIB state machine state
uint8_t GPIB_machineState = GPIB_MACHINE_STATE_RELEASED;
bool GPIB_machineHaveATN = false;

int16_t GPIB_loop() {
    switch(GPIB_machine_state) {
        case GPIB_MACHINE_STATE_RELEASED:
            if (GPIO_IF_getPinState(GPIO_PINS_ATN)) {
                GPIB_machineHaveATN = true;
                GPIB_machine_state = GPIB_MACHINE_STATE_RECEIVING_BYTE;
                GPIB_receiveByteStart(GPIB_RECEIVE_TIMEOUT);
            }
            break;
        case GPIB_MACHINE_STATE_ATN_ACTIVE:
            break;
        case GPIB_MACHINE_STATE_RECEIVING_BYTE:
            if (GPIB_receive_state == GPIB_RECEIVE_STATE_COMPLETE) {
                GPIB_machine_state = GPIB_MACHINE_STATE_RECEIVING_BYTE_COMPLETE;
            }
            break;
        case GPIB_MACHINE_STATE_RECEIVING_BYTE_COMPLETE:
            if (GPIB_machineHaveATN == true) {
                // Parse GPIB command
                // change GPIB machine state
            } else {
                // if (myAddress listening) then add data to user buffer
                // also check EOI flag
            }
            break;
        case GPIB_MACHINE_STATE_SENDING_BYTE:
            break;
        case GPIB_MACHINE_STATE_SENDING_BYTE_COMPLETE:
            break;
        default:
            // LOG: something wrong
            break;
    }
    //GPIB_receiveByteLoop();
    return -1;  // FIXME: return correct value
}



#define GPIB_RECEIVE_STATE_IDLE                 0
#define GPIB_RECEIVE_STATE_WAITFOR_DAV_ACTIVE   1
#define GPIB_RECEIVE_STATE_WAITFOR_DAV_PASSIVE  2
#define GPIB_RECEIVE_STATE_COMPLETE             3
#define GPIB_RECEIVE_STATE_TIMEOUT              4

// GPIB receive state machine state
uint8_t GPIB_receive_state = GPIB_RECEIVE_STATE_IDLE;
// GPIB received byte
uint8_t GPIB_receivedData = 0;

// don't mess too much with these becuse of unsignet math
// more info: https://davidmac.pro/posts/2020-12-22-arduino-millis-roll-over/
// timeout variables
uint32_t GPIB_receive_micros_start;
uint32_t GPIB_receive_micros_end;
uint32_t GPIB_receive_micros_timeout;


int16_t GPIB_receiveByteStart(uint32_t timeout) {
    GPIB_receive_micros_start = GPIO_IF_Tick();
    GPIB_receive_micros_timeout = timeout;
    
    (void)GPIO_IF_passive(GPIO_PINS_DAV);       // Just in case if pin state is wrong
    GPIO_IF_active(GPIO_PINS_NDAC);             // Just in case if pin state is wrong
    GPIB_receive_state = GPIB_RECEIVE_STATE_WAITFOR_DAV_ACTIVE;
    (void)GPIO_IF_passive(GPIO_PINS_NRFD);      // Tell controller that we are redy for data
    
    return -1;      // FIXME: retur correct value
}

int16_t GPIB_receiveByteLoop() {
    // receive byte complete. return data
    if (GPIB_receive_state == GPIB_RECEIVE_STATE_COMPLETE) {
        return GPIB_receivedData;
    }
    
    //check for timeout
    GPIB_receive_micros_end = GPIO_IF_Tick();
    if ( (GPIB_receive_micros_end - GPIB_receive_micros_start) >= GPIB_receive_micros_timeout ) {
        GPIB_receive_state = GPIB_RECEIVE_STATE_TIMEOUT;
    }
    switch (GPIB_receive_state) {
        case GPIB_RECEIVE_STATE_IDLE:
            break;
        case GPIB_RECEIVE_STATE_WAITFOR_DAV_ACTIVE:
            if (GPIO_IF_getPinState(GPIO_PINS_DAV)) {
                GPIO_IF_active(GPIO_PINS_NRFD);
                GPIB_receivedData = GPIO_IF_readData();
                (void)GPIO_IF_passive(GPIO_PINS_NDAC);
                GPIB_receive_state = GPIB_RECEIVE_STATE_WAITFOR_DAV_PASSIVE;
            }
            break;
        case GPIB_RECEIVE_STATE_WAITFOR_DAV_PASSIVE:
            if (!GPIO_IF_getPinState(GPIO_PINS_DAV)) {
                GPIO_IF_active(GPIO_PINS_NDAC);
                GPIB_receive_state = GPIB_RECEIVE_STATE_COMPLETE;
            }
            break;
        case GPIB_RECEIVE_STATE_TIMEOUT:
            // return timeout error
            return GPIB_RECEIVE_STATE_TIMEOUT * (-1);
            break;
        default:
            // LOG: something wrong
            break
    }
    return -1;      // FIXME: return correct value
}
