#pragma once

#include <stdint.h>

// initilise GPIB and set to correct start state
int16_t GPIB_init();

// call before end to uninitialise GPIO and GPIO
int16_t GPIB_finish();

// GPIB main loop and handle state machine
int16_t GPIB_loop();

// can be internal function?
// start receiving byte from GPIB BUS
// timeout in microseconds
// return: maybe something
int16_t GPIB_receiveByteStart(uint32_t timeout);

// can be internal function?
// loop while receive byte
// negative: error receiving byte
// if no data received, return  negative and reset state machine
// bits 0 -  7: received byte
// bits 8 - 14: additional status
int16_t GPIB_receiveByteLoop();
