#include "gpiointerface.h"
#include <pigpio.h>

#define bitRead(value, bit) (((value) >> (bit)) & 0x01)
#define bitSet(value, bit) ((value) |= (1UL << (bit)))
#define bitClear(value, bit) ((value) &= ~(1UL << (bit)))
#define bitToggle(value, bit) ((value) ^= (1UL << (bit)))
#define bitWrite(value, bit, bitvalue) ((bitvalue) ? bitSet(value, bit) : bitClear(value, bit))

uint8_t dataPinArray[] = {  GPIO_PINS_DIO1,
                            GPIO_PINS_DIO2,
                            GPIO_PINS_DIO3,
                            GPIO_PINS_DIO4,
                            GPIO_PINS_DIO5,
                            GPIO_PINS_DIO6,
                            GPIO_PINS_DIO7,
                            GPIO_PINS_DIO8
                            };

uint8_t controlPinArray[] = {   GPIO_PINS_NDAC,
                                GPIO_PINS_DAV,
                                GPIO_PINS_NRFD,
                                GPIO_PINS_ATN,
                                GPIO_PINS_EOI,
                                GPIO_PINS_SRQ,
                                GPIO_PINS_REN,
                                GPIO_PINS_IFC
                                };

// return:
// true if GPIO init completed
// false if GPIO init faileds
bool GPIO_IF_init() {
    gpioInitialise() < 0 ? return false;    //Failed to initilise GPIOs
    
    // Init all pins and set to passive state
    for (uint8_t i =0; i < 8; i++) {
        GPIO_IF_passive(dataPinArray[i]);
        GPIO_IF_passive(controlPinArray[i]);
    }
    return true;
}

void GPIO_IF_finish() {
    gpioTerminate();
}

void GPIO_IF_setCallback(uint8_t pin, GPIO_IF_Callback callback) {
    gpioSetAlertFunc(pin, callback);
}

uint32_t GPIO_IF_uSleep(uint32_t micros) {
    return gpioDelay(micros);
}

uint32_t GPIO_IF_tick() {
    return gpioTick();
}

bool GPIO_IF_passive(uint8_t pin) {
    gpioSetMode(pin, PI_INPUT);
    gpioSetPullUpDown(pin, PI_PUD_UP);
    return !((bool)gpioRead(pin));
}

void GPIO_IF_active(uint8_t pin) {
    gpioSetMode(pin, PI_OUTPUT);
    gpioWrite(pin, state);
}

void GPIO_IF_writeDataByte(uint8_t data) {
    for(uint8_t i = 0; i < 8; i++) {
        bitRead(data,i) ? GPIO_IF_active() : GPIO_IF_passive();
    }
}

uint8_t GPIO_IF_readDataByte() {
    uint8_t data;
    
    for (uint8_t i = 0; i < 8; i++) {
        GPIO_IF_passive(dataPinArray[i]) ? bitSet(data, i): bitClear(data, i);
    }
    return data;
}
