#pragma once

#include <stdint.h>

#define GPIO_PINS_DIO1  4
#define GPIO_PINS_DIO2  17
#define GPIO_PINS_DIO3  27
#define GPIO_PINS_DIO4  22
#define GPIO_PINS_DIO5  18
#define GPIO_PINS_DIO6  23
#define GPIO_PINS_DIO7  24
#define GPIO_PINS_DIO8  25

#define GPIO_PINS_NDAC  6
#define GPIO_PINS_DAV   19
#define GPIO_PINS_NRFD  5

#define GPIO_PINS_ATN   12
#define GPIO_PINS_EOI   26
#define GPIO_PINS_SRQ   13

#define GPIO_PINS_REN   20
#define GPIO_PINS_IFC   21

bool GPIO_IF_init();
bool GPIO_IF_finish();

typedef void (*GPIO_IF_Callback)(int gpio, int level, uint32_t tick);

void GPIO_IF_setCallback(uint8_t pin, GPIO_IF_Callback callback);

// delay for micros microseconds
// not recomended becaue will stall code

uint32_t GPIO_IF_uSleep(uint32_t micros);
// retur current system ticks in microseconds
// will overflow after approx. 1 hour 12 minutes
uint32_t GPIO_IF_tick();

// set GPIO line in passive mode
// and return 1 of GPIO line is in passive mode
bool GPIO_IF_passive(uint8_t pin);

// set GPIO pine in active mode
// no need to return state because it is already active
void GPIO_IF_active(uint8_t pin);

// get pin State is alias for GPIO_IF_passive()
#define GPIO_IF_getPinState(pin) (GPIO_IF_passive(pin))


uint8_t GPIO_IF_readData();
void GPIO_IF_writeData(uint8_t data);
