	.MODEL SMALL, C
	.CODE
	PUBLIC cx_i486cacheon

CR0_CD_ENB	EQU	0bfffffffh	; Enable cache with CR0
CR0_NW_ENB	EQU	0dfffffffh	; Enable writethru with CR0
					; Actually, the NW bit is hardwired
					; to 0 at all times on the Cyrix,
					; but we set and clear it anyway...

;
;	void cx_i486cacheon(void)
;
;	This routine flushes and enables the i486 internal cache.
;

cx_i486cacheon	PROC			; The proceedure name.

	.386P

; Use of MASM v5.1 should make this unecessary
;	push	ebp
;	movl	ebp, esp

	DB	0fh			; INVD instruction:
	DB	08h			; Flush i486 cache
	DB	0fh			; WBINVD instruction:
	DB	09h			; Flush i486 cache with write back
	jmp	cx_postinvd1		; jmp to next to force queue flush
cx_postinvd1:
	mov	eax, cr0		; cr0 -> eax
	and	eax, CR0_CD_ENB		; Turn "on" CD bit
	and	eax, CR0_NW_ENB		; Turn "on" NW bit
	mov	cr0, eax		; eax -> cr0

; Again use of MASM v5.1 should do this when it sees ENDP (I hope...)
;	pop	ebp

	ret

cx_i486cacheon	ENDP
		END

